// Rysunek 10.7. CommissionEmployee.java
// Klasa CommissionEmployee rozszerza klasę Employee.

public class CommissionEmployee extends Employee {
   private double grossSales; // Łączna tygodniowa sprzedaż.
   private double commissionRate; // Procent prowizji.

   // Konstruktor.
   public CommissionEmployee(String firstName, String lastName, 
      String socialSecurityNumber, double grossSales, 
      double commissionRate) {
      super(firstName, lastName, socialSecurityNumber);

      if (commissionRate <= 0.0 || commissionRate >= 1.0) { // Walidacja.
         throw new IllegalArgumentException(
            "Procent prowizji musi być > 0.0 i < 1.0");
      }

      if (grossSales < 0.0) { // Walidacja.
         throw new IllegalArgumentException("Łączna sprzedaż musi być >= 0.0");
      }

      this.grossSales = grossSales;
      this.commissionRate = commissionRate;
   } 

   // Ustaw łączną kwotę sprzedaży.
   public void setGrossSales(double grossSales) {
      if (grossSales < 0.0) { // Walidacja.
         throw new IllegalArgumentException("Łączna sprzedaż musi być >= 0.0");
      }

      this.grossSales = grossSales;
   } 

   // Zwróć łączną kwotę sprzedaży.
   public double getGrossSales() {return grossSales;}

   // Ustaw procent prowizji.
   public void setCommissionRate(double commissionRate) {
      if (commissionRate <= 0.0 || commissionRate >= 1.0) { // Walidacja.
         throw new IllegalArgumentException(
            "Procent prowizji musi być w zakresie > 0.0 i < 1.0");
      }

      this.commissionRate = commissionRate;
   } 

   // Zwróć procent prowizji.
   public double getCommissionRate() {return commissionRate;}

   // Wylicz zarobek. Przesłoń abstrakcyjną metodę earnings z Employee.
   @Override                                                           
   public double earnings() {                                          
      return getCommissionRate() * getGrossSales();                    
   }                                                                   

   // Zwróć tekstową reprezentację obiektu CommissionEmployee.
   @Override                                                   
   public String toString() {                                  
      return String.format("%s: %s%n%s: %,.2f zł; %s: %.2f",     
         "pracownik prowizyjny", super.toString(),
         "łączna sprzedaż", getGrossSales(),
         "procent prowizji", getCommissionRate());
   } 
} 



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
