// Rysunek 27.28. MathTutor.java
// Aplikacja wykorzystująca interfejs ProblemProvider do wyświetlenia zagadek matematycznych
package com.deitel.mathtutor;

import java.util.List;
import java.util.Random;
import java.util.Scanner;
import java.util.ServiceLoader;
import java.util.ServiceLoader.Provider;
import java.util.stream.Collectors;
import com.deitel.mathtutor.spi.Problem;
import com.deitel.mathtutor.spi.ProblemProvider;

public class MathTutor {
   private static Scanner input = new Scanner(System.in);

   public static void main(String[] args) {
      // Pobierz mechanizm wczytywania usług dla ProblemProvider
      ServiceLoader<ProblemProvider> serviceLoader = 
        ServiceLoader.load(ProblemProvider.class);

      // Pobierz listę dostawców usług
      List<Provider<ProblemProvider>> providersList = 
         serviceLoader.stream().collect(Collectors.toList());

      // Sprawdź, czy istnieją jacyś dostawcy
      if (providersList.isEmpty()) {
         System.out.println(
            "Wyłączenie MathTutor - nie zaleziono dostawców zadań.");
         return;
      }
      
      boolean shouldContinue = true;
      Random random = new Random();

      do {
         // Losowo wybierz wersję ProblemProvider
         ProblemProvider provider = 
            providersList.get(random.nextInt(providersList.size())).get();
         
         // Pobierz obiekt Problem
         Problem problem = provider.getProblem();

         // Wyświetl zadanie użytkownikowi
         showProblem(problem);
      } while (playAgain());
   }   

   // Wyświetl użytkownikowi zadanie do rozwiązania
   private static void showProblem(Problem problem) {
      String problemStatement = String.format("Ile wynosi %d %s %d? ", 
         problem.getLeftOperand(), problem.getOperation(), 
         problem.getRightOperand());
      
      // Wyświetl zadanie i zaczekaj na odpowiedź
      System.out.printf(problemStatement);
      int answer = input.nextInt();

      while (answer != problem.getResult()) {
         System.out.println("Odpowiedź nieprawidłowa. Spróbuj ponownie: ");
         System.out.printf(problemStatement);
         answer = input.nextInt();
      }

      System.out.println("Dobrze!");
   }

   // Następne zadanie?
   private static boolean playAgain() {
      System.out.printf("Następne zadanie? t, aby kontynuować, n, aby przerwać: ");
      String response = input.next();

      return response.toLowerCase().startsWith("t");
   }
}

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
