// Rysunek 24.29. DisplayQueryResultsController.java
// Kontroler dla aplikacji wyświetlania wyników zapytania
import java.sql.SQLException;
import java.util.regex.PatternSyntaxException;

import javafx.embed.swing.SwingNode;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Alert;
import javafx.scene.control.Alert.AlertType;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.layout.BorderPane;

import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.RowFilter;           
import javax.swing.table.TableModel;    
import javax.swing.table.TableRowSorter;

public class DisplayQueryResultsController {
   @FXML private BorderPane borderPane;
   @FXML private TextArea queryTextArea;
   @FXML private TextField filterTextField;

   // Adres URL bazy danych, nazwa użytkownika i hasło
   private static final String DATABASE_URL = "jdbc:derby:books";
   private static final String USERNAME = "deitel";
   private static final String PASSWORD = "deitel";
   
   // Domyślne zapytanie pobiera wszystkie dane z tabeli Authors
   private static final String DEFAULT_QUERY = "SELECT * FROM authors";
   
   // Używane w celu konfiguracji JTable związanej z wyświetlaniem i sortowaniem
   private ResultSetTableModel tableModel;
   private TableRowSorter<TableModel> sorter;

   public void initialize() {
      queryTextArea.setText(DEFAULT_QUERY);

      // Utworzenie ResultSetTableModel i wyświetlenie tabeli bazy danych
      try {
         // Utworzenie TableModel dla wyników z DEFAULT_QUERY
         tableModel = new ResultSetTableModel(DATABASE_URL,            
            USERNAME, PASSWORD, DEFAULT_QUERY);                        
         
         // Utworzenie JTable na podstawie tableModel
         JTable resultTable = new JTable(tableModel);

         // Ustawienie konfiguracji wierszy dla JTable
         sorter = new TableRowSorter<TableModel>(tableModel);
         resultTable.setRowSorter(sorter);             

         // Konfiguracja SwingNode w celu wyświetlenia JTable, a następnie dodanie go do borderPane
         SwingNode swingNode = new SwingNode();
         swingNode.setContent(new JScrollPane(resultTable));
         borderPane.setCenter(swingNode);
      }
      catch (SQLException sqlException) {
         displayAlert(AlertType.ERROR, "Błąd bazy danych", 
            sqlException.getMessage());
         tableModel.disconnectFromDatabase(); // Zamknięcie połączenia
         System.exit(1); // Zakończenie aplikacji
      } 
   }

   // Odpytanie bazy danych i wyświetlenie wyników w JTable
   @FXML
   void submitQueryButtonPressed(ActionEvent event) {
      // Wykonanie nowego zapytania
      try {
         tableModel.setQuery(queryTextArea.getText());
      } 
      catch (SQLException sqlException) {
         displayAlert(AlertType.ERROR, "Błąd bazy danych", 
            sqlException.getMessage());
         
         // Próba odzyskania stabilizacji przez wywołanie
         // zapytania domyślnego
         try {
            tableModel.setQuery(DEFAULT_QUERY);
            queryTextArea.setText(DEFAULT_QUERY);
         } 
         catch (SQLException sqlException2) {
            displayAlert(AlertType.ERROR, "Błąd bazy danych", 
               sqlException2.getMessage());
            tableModel.disconnectFromDatabase(); // Zamknięcie połączenia
            System.exit(1); // Zakończenie aplikacji
         } 
      } 
   }

   // Zastosowanie wskazanego filtru dla wyników
   @FXML
   void applyFilterButtonPressed(ActionEvent event) {
      String text = filterTextField.getText();

      if (text.length() == 0) {
         sorter.setRowFilter(null);
      }
      else {
         try {
            sorter.setRowFilter(RowFilter.regexFilter(text));
         } 
         catch (PatternSyntaxException pse) {
            displayAlert(AlertType.ERROR, "Błąd wyrażenia regularnego", 
               "Niepoprawny wzorzec");
         }
      }
   }

   // Wyświetlenie okna dialogowego Alert
   private void displayAlert(
      AlertType type, String title, String message) {
      Alert alert = new Alert(type);
      alert.setTitle(title);
      alert.setContentText(message);
      alert.showAndWait();
   }
}



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
