// Rysunek 23.28. FindPrimesController.java
// Wyświetlanie liczb pierwszych w momencie ich znalezienia oraz aktualizacja kontrolki ProgressBar
import java.util.concurrent.Executors;
import java.util.concurrent.ExecutorService;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Label;
import javafx.scene.control.ListView;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.TextField;

public class FindPrimesController {
   @FXML private TextField inputTextField;
   @FXML private Button getPrimesButton;
   @FXML private ListView<Integer> primesListView;
   @FXML private Button cancelButton;
   @FXML private ProgressBar progressBar;
   @FXML private Label statusLabel;

   // Przechowuje listę liczb pierwszych otrzymaną z PrimeCalculatorTask
   private ObservableList<Integer> primes = 
      FXCollections.observableArrayList();
   private PrimeCalculatorTask task; // Znajdź liczby pierwsze

   // Dowiązuje elementy primesListView do liczb pierwszych z ObservableList
   public void initialize() {
      primesListView.setItems(primes);
   }

   // Uruchamia obliczanie w tle liczb pierwszych
   @FXML
   void getPrimesButtonPressed(ActionEvent event) {
      primes.clear();

      // Pobranie maksymalnej liczby pierwszej do znalezienia
      try {
         int input = Integer.parseInt(inputTextField.getText());
         task = new PrimeCalculatorTask(input); // Utworz zadanie

         // Wyświetl komunikat zadania w statusLabel
         statusLabel.textProperty().bind(task.messageProperty());

         // Uaktualniaj progressBar na podstawie właściwości progressProperty zadania
         progressBar.progressProperty().bind(task.progressProperty());

         // Zapamiętuj wyniki pośrednie w ObservableList
         task.valueProperty().addListener(
            (observable, oldValue, newValue) -> {
               if (newValue != 0) { // Zadanie zwraca 0 w momencie zakończenia
                  primes.add(newValue);
                  primesListView.scrollTo(
                     primesListView.getItems().size());
               }
            });

         // Gdy zadanie się zaczyna, 
         // zablokuj getPrimesButton i odblokuj cancelButton.
         task.setOnRunning((succeededEvent) -> {
            getPrimesButton.setDisable(true);
            cancelButton.setDisable(false);
         });

         // Gdy zadanie się zakończy z sukcesem, 
         // odblokuj getPrimesButton i zablokuj cancelButton.
         task.setOnSucceeded((succeededEvent) -> {
            getPrimesButton.setDisable(false);
            cancelButton.setDisable(true);
         });

         // Tworzy obiekt ExecutorService w celu zarządzania wątkami.
         ExecutorService executorService = 
            Executors.newFixedThreadPool(1);
         executorService.execute(task); // Uruchamia zadanie.
         executorService.shutdown();
      }
      catch (NumberFormatException e) {
         inputTextField.setText("Wpisz liczbę całkowitą");
         inputTextField.selectAll();
         inputTextField.requestFocus();
      }  
   }

   // Anuluj zadanie po kliknięciu przycisku Anuluj.
   @FXML
   void cancelButtonPressed(ActionEvent event) {
      if (task != null) {
         task.cancel(); // Przerywa zadanie.
         getPrimesButton.setDisable(false);
         cancelButton.setDisable(true);
      }
   }
}


/**************************************************************************
* (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
* Pearson Education, Inc. All Rights Reserved.                           *
*                                                                        *
* DISCLAIMER: The authors and publisher of this book have used their     *
* best efforts in preparing the book. These efforts include the          *
* development, research, and testing of the theories and programs        *
* to determine their effectiveness. The authors and publisher make       *
* no warranty of any kind, expressed or implied, with regard to these    *
* programs or to the documentation contained in these books. The authors *
* and publisher shall not be liable in any event for incidental or       *
* consequential damages in connection with, or arising out of, the       *
* furnishing, performance, or use of these programs.                     *
*************************************************************************/
