// Rysunek 23.8. SimpleArray.java
// Klasa, która zarządza tablicą liczb całkowitych współdzieloną przez wiele wątków 
// i używa synchronizacji
import java.security.SecureRandom;
import java.util.Arrays;

public class SimpleArray {
   private static final SecureRandom generator = new SecureRandom();
   private final int[] array; // Współdzielona tablica liczb całkowitych
   private int writeIndex = 0; // Współdzielony indeks następnego elementu do zapisania

   // Konstrukcja SimpleArray o zadanym rozmiarze
   public SimpleArray(int size) {
      array = new int[size];
   } 

   // Dodanie wartości do współdzielonej tablicy
   public synchronized void add(int value) {
      int position = writeIndex; // Zapamiętanie indeksu zapisu

      try {
         // W aplikacji produkcyjnej nie należy zasypiać, gdy trzyma się blokadę
         Thread.sleep(generator.nextInt(500)); // Tylko w celach demonstracyjnych
      } 
      catch (InterruptedException ex) {
         Thread.currentThread().interrupt(); 
      } 

      // Umieszczenie wartości w odpowiednim elemencie
      array[position] = value;             
      System.out.printf("%s zapisał %2d do elementu %d%n", 
         Thread.currentThread().getName(), value, position);

      ++writeIndex; // Zwiększ indeks elementu, w którym będzie zapisywana wartość
      System.out.printf("Następny indeks zapisu: %d%n", writeIndex);
   } 
   
   // Służy do wyświetlenia zawartości współdzielonej tablicy
   @Override
   public synchronized String toString() {
      return Arrays.toString(array);
   } 
}



/**************************************************************************
 * (C) Copyright 1992-2015 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/