// Rysunek 20.9. StackTest2.java
// Przekazywanie uogólnionych obiektów Stack do uogólnionych metod
import java.util.NoSuchElementException;
      
public class StackTest2 {
   public static void main(String[] args) {
      Double[] doubleElements = {1.1, 2.2, 3.3, 4.4, 5.5};
      Integer[] integerElements = {1, 2, 3, 4, 5, 6, 7, 8, 9, 10};
      
      // Utworzenie Stack<Double> i Stack<Integer>
      Stack<Double> doubleStack = new Stack<>(5); 
      Stack<Integer> integerStack = new Stack<>(); 

      // Umieszczenie elementów doubleElements w doubleStack      
      testPush("doubleStack", doubleStack, doubleElements);       
      testPop("doubleStack", doubleStack); // Zdjęcie z doubleStack
 
      // Umieszczenie elementów integerElements w integerStack
      testPush("integerStack", integerStack, integerElements);       
      testPop("integerStack", integerStack); // Zdjęcie z integerStack
   }

   // Uogólniona metoda testPush umieszcza elementy na stosie
   public static <E> void testPush(String name , Stack<E> stack,
      E[] elements) {                                           
      System.out.printf("%nUmieszczanie elementów w %s%n", name);

      // Umieszczanie elementów na stosie
      for (E element : elements) {
         System.out.printf("%s ", element);
         stack.push(element); // Wykonanie push dla stack
      }
   } 

   // Uogólniona metoda testPop zdejmująca elementy ze stosu
   public static <E> void testPop(String name, Stack<E> stack) {
      // Zdejmowanie elementów ze stosu
      try {
         System.out.printf("%nZdejmowanie elementów z %s%n", name);
         E popValue; // Zapamiętanie elementu usuniętego ze stosu

         // Zdjęcie wszyskich elementów ze stosu
         while (true) {
            popValue = stack.pop(); 
            System.out.printf("%s ", popValue);
         }
      } 
      catch(NoSuchElementException noSuchElementException) {
         System.out.println();
         noSuchElementException.printStackTrace();
      }
   }
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/