// Rysunek 17.12. ArraysAndStreams2.java
// Przykład użycia lambd i strumieni dla tablicy obiektów String
import java.util.Arrays;
import java.util.Comparator;
import java.util.stream.Collectors;

public class ArraysAndStreams2 {
   public static void main(String[] args) {
      String[] strings = 
         {"Czerwony", "pomarańczowy", "Szary", "zielony", "Niebieski", "indygo", "Fioletowy"};

      // Wyświetl pierwotne teksty
      System.out.printf("Pierwotne teksty: %s%n", Arrays.asList(strings));

      // Teksty dużymi literami
      System.out.printf("Teksty dużymi literami: %s%n",
         Arrays.stream(strings)             
               .map(String::toUpperCase)   
               .collect(Collectors.toList()));

      // Teksty mniejsze od "n" (bez względu na wielkość liter) posortowane rosnąco
      System.out.printf("Teksty mniejsze od n posortowane rosnąco: %s%n",
         Arrays.stream(strings)                            
               .filter(s -> s.compareToIgnoreCase("n") < 0)
               .sorted(String.CASE_INSENSITIVE_ORDER)
               .collect(Collectors.toList()));             

      // Teksty mniejsze od "n" (bez względu na wielkość liter) posortowane malejąco
      System.out.printf("Teksty mniejsze od n posortowane malejąco: %s%n",
         Arrays.stream(strings)
               .filter(s -> s.compareToIgnoreCase("n") < 0)
               .sorted(String.CASE_INSENSITIVE_ORDER.reversed())
               .collect(Collectors.toList()));
   }
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
