// Rysunek 7.25. DrawRainbowController.java
// Rysowanie tęczy za pomocą łuków.
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.canvas.Canvas;
import javafx.scene.canvas.GraphicsContext;
import javafx.scene.paint.Color;
import javafx.scene.shape.ArcType;

public class DrawRainbowController { 
   @FXML private Canvas canvas;

   // Kolory do użycia w tęczy, zaczynając od najbardziej wewnętrznego.
   // Dwa białe wpisy tworzą pusty łuk na środku.
   private final Color[] colors = {
      Color.WHITE, Color.WHITE, Color.VIOLET, Color.INDIGO, Color.BLUE,
      Color.GREEN, Color.YELLOW, Color.ORANGE, Color.RED};
  
   // Rysuje tęczę za pomocą łuków.
   @FXML
   void drawRainbowButtonPressed(ActionEvent event) {
      // Pobierz GraphicsContext, który posłuży do rysowania na kanwie.
      GraphicsContext gc = canvas.getGraphicsContext2D();

      final int radius = 20; // Promień łuku.
      
      // Narysuj tęczę blisko dolnego środka.
      final double centerX = canvas.getWidth() / 2;
      final double maxY = canvas.getHeight() - 10;

      // Rysuje wypełnione łuki od najbardziej zewnętrznego.
      for (int counter = colors.length; counter > 0; counter--) {
         // Ustaw kolor aktualnego łuku.
         gc.setFill(colors[counter - 1]);
         
         // Wypełnij łuk od 0 do 180 stopni.
         gc.fillArc(centerX - counter * radius,
            maxY - counter * radius, counter * radius * 2, 
            counter * radius * 2, 0, 180, ArcType.OPEN);
      } 
   }
}

/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
