// Rysunek 7.21. InitArray.java
// Inicjalizacja tablicy za pomocą argumentów wiersza poleceń.

public class InitArray {
   public static void main(String[] args) {
      // Sprawdź liczbę argumentów z wiersza poleceń.
      if (args.length != 3) {
         System.out.printf(
            "Błąd: wpisz ponownie całe polecenie razem%n" +
            "z rozmiarem tablicy, wartością początkową i inkrementacją.%n");
      }
      else {
         // Pobierz rozmiar tablicy z pierwszego argumentu wiersza poleceń.
         int arrayLength = Integer.parseInt(args[0]); 
         int[] array = new int[arrayLength]; 

         // Pobierz wartość początkową i inkrementację z wiersza poleceń.
         int initialValue = Integer.parseInt(args[1]);
         int increment = Integer.parseInt(args[2]);   

         // Oblicz wartości elementów tablicy.
         for (int counter = 0; counter < array.length; counter++) {
            array[counter] = initialValue + increment * counter;   
         }

         System.out.printf("%s%8s%n", "Indeks", "Wartość");
         
         // Wyświetl indeks i wartość z tablicy.
         for (int counter = 0; counter < array.length; counter++) {
            System.out.printf("%6d%8d%n", counter, array[counter]);
         }
      } 
   } 
} 


/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
