// Rysunek 5.11. AutoPolicy.java
// Klasa reprezentująca ubezpieczenie samochodu
public class AutoPolicy {
   private int accountNumber; // Numer ubezpieczenia
   private String makeAndModel; // Samochód, którego dotyczy ubezpieczenie
   private String state; // Dwuliterowy skrót stanu

   // Konstruktor
   public AutoPolicy(int accountNumber, String makeAndModel, 
      String state) {
      this.accountNumber = accountNumber;
      this.makeAndModel = makeAndModel;
      this.state = state;
   }

   // Ustawia accountNumber
   public void setAccountNumber(int accountNumber) {
      this.accountNumber = accountNumber;
   }

   // Zwraca accountNumber
   public int getAccountNumber() {
      return accountNumber;
   } 

   // Ustawia makeAndModel
   public void setMakeAndModel(String makeAndModel) {
      this.makeAndModel = makeAndModel;
   }

   // Zwraca makeAndModel
   public String getMakeAndModel() {
      return makeAndModel;
   } 

   // Ustawia state
   public void setState(String state) {
      this.state = state;
   }

   // Zwraca state
   public String getState() {
      return state;
   }

   // Metoda predykatowa zwraca informację, czy w stanie stosuje się ubezpieczenia typu no-fault
   public boolean isNoFaultState() {
      boolean noFaultState; 

      // Określ, czy w stanie stosuje się ubezieczenie typu no-fault
      switch (getState()) { // Pobierz skrót stanu metodą obiektu AutoPolicy
         case "MA": case "NJ": case "NY": case "PA":                     
            noFaultState = true;                                         
            break;                                                       
         default:                                                        
            noFaultState = false;                                        
            break;                                                       
      }                                                                  

      return noFaultState;
   } 
} 



/**************************************************************************
 * (C) Copyright 1992-2018 by Deitel & Associates, Inc. and               *
 * Pearson Education, Inc. All Rights Reserved.                           *
 *                                                                        *
 * DISCLAIMER: The authors and publisher of this book have used their     *
 * best efforts in preparing the book. These efforts include the          *
 * development, research, and testing of the theories and programs        *
 * to determine their effectiveness. The authors and publisher make       *
 * no warranty of any kind, expressed or implied, with regard to these    *
 * programs or to the documentation contained in these books. The authors *
 * and publisher shall not be liable in any event for incidental or       *
 * consequential damages in connection with, or arising out of, the       *
 * furnishing, performance, or use of these programs.                     *
 *************************************************************************/
