/******************************************************************************
 *  Kompilacja:  javac Merge.java
 *  Wykonanie:    java Merge < input.txt
 *  Pliki z danymi:   http://www.cs.princeton.edu/introcs/43sort/8words.txt
 *                http://www.cs.princeton.edu/introcs/43sort/TomSawyer.txt
 *
 *  Prosta implementacja sortowania przez scalanie działająca w czasie n log n.
 *
 *  Uwagi
 *  ---------
 *     - liczba porównań wynosi najwyżej n lg n
 *     - sortowanie jest stabilne
 *
 *  % java Merge < 8words.txt
 *  and but had him his the was you 
 *
 ******************************************************************************/

public class Merge {

   /***************************************************************************
    *  Scala podtablice a[lo] .. a[mid-1] i a[mid] .. a[hi-1] w
    *  a[lo] .. a[hi-1] za pomocą tablicy pomocniczej aux[].
    *
    *  Warunek wstępny:   dwie podtablice są uporządkowane rosnąco
    *  Warunek końcowy:  a[lo] .. a[hi-1] jest uporządkowane rosnąco
    *
    ***************************************************************************/
    private static void merge(Comparable[] a, Comparable[] aux, int lo, int mid, int hi) {
        int i = lo, j = mid;
        for (int k = lo; k < hi; k++) {
            if      (i == mid)                 aux[k] = a[j++];
            else if (j == hi)                  aux[k] = a[i++];
            else if (a[j].compareTo(a[i]) < 0) aux[k] = a[j++];
            else                               aux[k] = a[i++];
        }

        // kopiowanie z powrotem
        for (int k = lo; k < hi; k++)
            a[k] = aux[k];
    }


   /***************************************************************************
    *  Sortuje przez scalanie podtablicę a[lo] .. a[hi-1] za pomocą
    *  tablicy pomocniczej aux[].
    ***************************************************************************/
    public static void sort(Comparable[] a, Comparable[] aux, int lo, int hi) {

        // przypadek bazowy
        if (hi - lo <= 1) return;

        // rekurencyjne sortowanie każdej połowy
        int mid = lo + (hi - lo) / 2;
        sort(a, aux, lo, mid);
        sort(a, aux, mid, hi);

        // ponowne scalanie
        merge(a, aux, lo, mid, hi);
    }


   /***************************************************************************
    *  Sortowanie tablicy przez scalanie.
    ***************************************************************************/
    public static void sort(Comparable[] a) {
        int n = a.length;
        Comparable[] aux = new Comparable[n];
        sort(a, aux, 0, n);
    }

   /***************************************************************************
    *  Sortowanie podtablicy a[lo..hi] przez scalanie.
    ***************************************************************************/
    public static void sort(Comparable[] a, int lo, int hi) {
        int n = hi - lo + 1;
        Comparable[] aux = new Comparable[n];
        sort(a, aux, lo, hi);
    }


   /***************************************************************************
    *  Sprawdzanie, czy tablica jest posortowana; przydatne do debugowania.
    ***************************************************************************/
    private static boolean isSorted(Comparable[] a) {
        for (int i = 1; i < a.length; i++)
            if (a[i].compareTo(a[i-1]) < 0) return false;
        return true;
    }

   /***************************************************************************
    *  Wyświetlanie wyników.
    ***************************************************************************/
    public static void show(Comparable[] a) {
        for (int i = 0; i < a.length; i++)
            StdOut.println(a[i]);
    }


   /***************************************************************************
    *  Klient testowy.
    ***************************************************************************/
    public static void main(String[] args) {
        String[] a = StdIn.readAllStrings();
        Merge.sort(a);
        assert isSorted(a);
        for (int i = 0; i < a.length; i++) {
            StdOut.print(a[i] + " ");
        }
        StdOut.println();
    }
}