/******************************************************************************
 *  Kompilacja:  javac LoadBalance.java
 *  Wykonanie:    java LoadBalance m n s
 *  Zależności: Queue.java RandomQueue.java StdDraw.java StdStats.java
 *
 *  Symuluje proces przypisywania n elementów do zbioru m serwerów.
 *  Żądania są dodawane do najkrótszej z losowo wybranych s kolejek.
 *
 ******************************************************************************/

public class LoadBalance {
    public static void main(String[] args) {

        int m = Integer.parseInt(args[0]);
        int n = Integer.parseInt(args[1]);
        int s = Integer.parseInt(args[2]);

        // Tworzy kolejki serwera.
        RandomQueue<Queue<Integer>> servers = new RandomQueue<Queue<Integer>>();

        for (int i = 0; i < m; i++) {
            servers.enqueue(new Queue<Integer>());
        }

        // Przypisuje element do serwera
        for (int j = 0; j < n; j++) {

            // Wybiera losowy serwer; aktualizuje kolejkę, jeśli wylosowano nowe min.
            Queue<Integer> min = servers.sample();
            for (int k = 1; k < s; k++) {
                Queue<Integer> queue = servers.sample();
                if (queue.length() < min.length()) min = queue;
            }

            // min to najkrótsza kolejka
            min.enqueue(j);
        }

        int i = 0;
        double[] lengths = new double[m];
        for (Queue<Integer> queue : servers) {
            lengths[i++] = queue.length();
            StdDraw.setYscale(0, 2.0*n/m);
            StdStats.plotBars(lengths);
        }
    }
}