public class StdStats
{
   public static double max(double[] a)
   {  // Obliczenie wartości maksymalnej w a[].
      double max = Double.NEGATIVE_INFINITY;
      for (int i = 0; i < a.length; i++)
         if (a[i] > max) max = a[i];
      return max;
   }

   public static double mean(double[] a)
   { // Obliczenie średniej z wartości w a[].
      double sum = 0.0;
      for (int i = 0; i < a.length; i++)
         sum = sum + a[i];
      return sum / a.length;
   }

   public static double var(double[] a)
   {  // Obliczenie wariancji wartości w a[].
      double avg = mean(a);
      double sum = 0.0;
      for (int i = 0; i < a.length; i++)
         sum += (a[i] - avg) * (a[i] - avg);
      return sum / (a.length - 1);
   }

   public static void plotPoints(double[] a)
   {  // Rysowanie punktów o współrzędnych (i, a[i]).
      int n = a.length;
      StdDraw.setXscale(-1, n);
      StdDraw.setPenRadius(1/(3.0*n));
      for (int i = 0; i < n; i++)
         StdDraw.point(i, a[i]);
   }

   public static void plotLines(double[] a)
   {  // Rysowanie odcinków pomiędzy punktami (i, a[i]).
      int n = a.length;
      StdDraw.setXscale(-1, n);
      StdDraw.setPenRadius();
      for (int i = 1; i < n; i++)
         StdDraw.line(i-1, a[i-1], i, a[i]);
   }

   public static void plotBars(double[] a)
   {  // Rysowanie słupków od (0, a[i]) do (i, a[i]).
      int n = a.length;
      StdDraw.setXscale(-1, n);
      for (int i = 0; i < n; i++)
         StdDraw.filledRectangle(i, a[i]/2, 0.25, a[i]/2);
   }

   public static double stddev(double[] a)
   {  return Math.sqrt(var(a)); }
   // Metody rysujące znajdują się na listingu 2.2.5.

   public static void main(String[] args)
   {
      StdDraw.setYscale(-1.0, 1.0);
      double[] hi;
      hi = PlayThatTune.tone(880, 0.01);
      StdStats.plotPoints(hi);
      StdStats.plotPoints(hi);
   }
}
