/******************************************************************************
 *  Kompilacja:  javac BinarySearch.java
 *  Wykonanie:    java BinarySearch wordlist.txt < input.txt
 *  Pliki z danymi:   http://www.cs.princeton.edu/introcs/43sort/emails.txt
 *                http://www.cs.princeton.edu/introcs/43sort/whitelist.txt
 *
 *  Wczytuje listę słów w porządku alfabetycznym z podanego pliku.
 *  Następnie prosi użytkownika o wpisanie słów i podaje, które z tych
 *  słów *nie* znajdują się na wczytanej liście.
 * 
 *  % java BinarySearch whitelist.txt < emails.html
 *  marvin@spam
 *  mallory@spam
 *  eve@airport
 *
 ******************************************************************************/

import java.util.Arrays;

public class BinarySearch {

    // zwraca indeks klucza w posortowanej tablicy a[]; zwraca -1, jeśli klucza nie znaleziono
    public static int search(String key, String[] a) {
        return search(key, a, 0, a.length);
    }
    public static int search(String key, String[] a, int lo, int hi) {
System.out.println("lo  = " + lo);
System.out.println("hi  = " + hi);
		// możliwe indeksy klucza występuje w przedziale [lo, hi)
        if (hi <= lo) return -1;
        int mid = lo + (hi - lo) / 2;
        int cmp = a[mid].compareTo(key);
        if      (cmp > 0) return search(key, a, lo, mid);
        else if (cmp < 0) return search(key, a, mid+1, hi);
        else              return mid;
    }


	// biała lista (filtr wyjątków)
    public static void main(String[] args) {
        In in = new In(args[0]);
        String s = in.readAll();
        String[] words = s.split("\\s+");
        System.err.println("Zakończono wczytywanie słów");

        // sortowanie słów (jeśli to konieczne)
        Arrays.sort(words);
        System.err.println("Zakończono sortowanie słów");

        // wyświetlanie prośby do użytkownika o wprowadzenie słowa i sprawdzanie, czy słowo znajduje się na liście
        while (!StdIn.isEmpty()) {
            String key = StdIn.readString();
            if (search(key, words) < 0) StdOut.println(key);
        }
    }
}
