/******************************************************************************
 *  Kompilacja:  javac ResizingArrayStackOfStrings.java
 *  Wykonanie:    java ResizingArrayStackOfStrings < input.txt
 *  Zależności: StdIn.java StdOut.java
 *  Pliki z danymi:   https://introcs.cs.princeton.edu/43stack/tobe.txt
 *  
 *  Implementacja stosu z użyciem rozszerzalnej tablicy.
 *
 *  % more tobe.txt 
 *  to be or not to - be - - that - - - is
 *
 *  % java ResizingArrayStack < tobe.txt
 *  to be not that or be (na stosie pozostało: 2)
 *
 ******************************************************************************/

import java.util.Iterator;
import java.util.NoSuchElementException;

public class ResizingArrayStackOfStrings implements Iterable<String> {
    private String[] items;     // tablica ciągów znaków
    private int n = 0;          // liczba elementów na stosie

    // tworzy pusty stos
    public ResizingArrayStackOfStrings() {
        items = new String[2];
    }

    public boolean isEmpty() {
        return n == 0;
    }

    public int size() {
        return n;
    }


    // zmienia wielkość tablicy z elementami
    private void resize(int capacity) {
        assert capacity >= n;
        String[] temp = new String[capacity];
        for (int i = 0; i < n; i++)
            temp[i] = items[i];
        items = temp;
    }

    // umieszcza nowy element na stosie
    public void push(String item) {
        if (n == items.length) resize(2*items.length);  // w razie potrzeby podwaja długość tablicy
        items[n++] = item;                              // dodaje element
    }

    // usuwa i zwraca ostatnio dodany element
    public String pop() {
        if (isEmpty()) throw new NoSuchElementException("Stos pusty");
        String item = items[n-1];
        items[n-1] = null;        // aby uniknąć zbędnych referencji
        n--;
        // w razie potrzeby zmniejsza wielkość tablicy
        if (n > 0 && n == items.length/4) resize(items.length/2);
        return item;
    }


    public Iterator<String> iterator() {
        return new ReverseArrayIterator();
    }

    // iterator; nie implementuje opcjonalnej metody remove()
    private class ReverseArrayIterator implements Iterator<String> {
        private int i = n-1;
        public boolean hasNext()  { return i >= 0;                              }
        public void remove()      { throw new UnsupportedOperationException();  }

        public String next() {
            if (!hasNext()) throw new NoSuchElementException();
            return items[i--];
        }
    }



   /***************************************************************************
    * Metoda testowa
    ***************************************************************************/
    public static void main(String[] args) {
        ResizingArrayStackOfStrings stack = new ResizingArrayStackOfStrings();
        while (!StdIn.isEmpty()) {
            String item = StdIn.readString();
            if (!item.equals("-")) stack.push(item);
            else if (!stack.isEmpty()) StdOut.print(stack.pop() + " ");
        }
        StdOut.println("(na stosie pozostało: " + stack.size() + ")");
    }
}