
public class Body
{
   private Vector r;
   private Vector v;
   private final double mass;

   public Body(Vector r0, Vector v0, double m0)
   { r = r0; v = v0; mass = m0; }

   public void move(Vector force, double dt)
   {  // Zmiana położenia i prędkości.
      Vector a = force.scale(1/mass);
      v = v.plus(a.scale(dt));
      r = r.plus(v.scale(dt));
   }

   public Vector forceFrom(Body b)
   {  // Obliczenie siły działającej na to ciało przez b.
      Body a = this;
      double G = 6.67e-11;
      Vector delta = b.r.minus(a.r);
      double dist = delta.magnitude();
      double magnitude = (G * a.mass * b.mass)
        / (dist * dist);
      Vector force = delta.direction().scale(magnitude);
      return force;
   }

   public void draw()
   {
      StdDraw.setPenRadius(0.0125);
      StdDraw.point(r.cartesian(0), r.cartesian(1));
   }
}
