/**
  Listingi z rozdziału 1.
  Autor: Luis Atencio
*/

"use strict";

const R = require('ramda');
const _ = require('lodash');

// Wyświetlanie wersji
console.log('Wersja biblioteki Lodash: ' + _.VERSION);

QUnit.module('Rozdział 1.');

// W rozdziale 1. używany jest alias "run". Pozwala to oswoić
// się z techniką kompozycji.
const run = R.compose;

QUnit.test("Listing 1.1. Funkcyjna metoda printMessage", function () {
	// W książce wyniki wyświetlane są za pomocą modelu DOM. Na serwerze
	// Node zamiast modelu DOM używana jest konsola. Ogólny mechanizm
	// jest jednak taki sam.

    const printToConsole = str => {
    	console.log(str);
    	return str;
    };
    const toUpperCase = str => str.toUpperCase();
    const echo = R.identity; 

    const printMessage = run(printToConsole, toUpperCase, echo);	
    assert.equal(printMessage('Witaj, świecie'), 'WITAJ, ŚWIECIE');
});
 
QUnit.test("Listing 1.2. Rozszerzanie funkcji printMessage", function () {
    // W książce wyniki wyświetlane są za pomocą modelu DOM. Na serwerze
	// Node zamiast modelu DOM używana jest konsola. Ogólny mechanizm
	// jest jednak taki sam.

    const printToConsole = str => {
    	console.log(str);
    	return str;
    };
    const toUpperCase = str => str.toUpperCase();
    const echo = R.identity; 

    const repeat = (times) => {
    	return function (str = '') {
    		let tokens = [];
	    	for(let i = 0; i < times; i++) {
	    		tokens.push(str);
	    	}
    		return tokens.join(' ');	
    	};    	
    };

    const printMessage = run(printToConsole, repeat(3), toUpperCase, echo);	
    assert.equal(printMessage('Witaj, świecie'), 'WITAJ, ŚWIECIE WITAJ, ŚWIECIE WITAJ, ŚWIECIE');
});

QUnit.test("Listing 1.3 Imperatywna funkcja showStudent z efektami ubocznymi", function () {
	// W książce w rozdziale 1. używana jest atrapa obiektu z danymi
    const db = require('./helper').db;
    
    function showStudent(ssn) {
    	let student = db.find(ssn);    	
    	if(student !== null) {
    		let studentInfo = `<p>${student.ssn},${student.firstname},${student.lastname}</p>`;
			console.log(studentInfo);
    		return studentInfo;
    	}
    	else {
    		throw new Error('Studenta nie znaleziono');
    	}
    }
    
    assert.equal(showStudent('444-44-4444'), '<p>444-44-4444,Alonzo,Church</p>');
});

// Alias dla wywołania curry
const curry = R.curry;

QUnit.test("Listing 1.4. Dekompozycja programu showStudent", function () {
    // W książce w rozdziale 1. używana jest atrapa obiektu z danymi.
	// Zamiast dodawać wyniki do modelu DOM, tu kod wyświetla je w konsoli

    const db = require('./helper').db;
    
    const find = curry((db, id) => {
    	let obj = db.find(id);
    	if(obj === null) {
    		throw new Error('Obiektu nie znaleziono!');
    	}
    	return obj;
    });
    
    const csv = student => `${student.ssn}, ${student.firstname}, ${student.lastname}`;

    const append = curry( (source, info) => {
    	source(info);
    	return info;
    });

    const showStudent = run(
    	append(console.log),
    	csv,
    	find(db)
	);

	assert.equal(showStudent('444-44-4444'), '444-44-4444, Alonzo, Church');
});

QUnit.test("Listing 1.5. Programowanie z użyciem łańcuchów funkcji", function () {
	// Tablica z danymi o zapisach trzech studentów
	const enrollments = [
		{
			enrolled: 3,  // Student zapisał się na 3 kursy i uzyskał średnią punktów 90
			grade: 90
		},
		{
			enrolled: 1,  // Student zapisał się na 1 kurs i uzyskał średnią punktów 100
			grade: 100
		},
		{
			enrolled: 1,  //  Student zapisał się na 1 kurs i uzyskał średnią punktów 87
			grade: 87
		},		
	];

	const result = 
	          _.chain(enrollments)
	 		   .filter(student => student.enrolled > 1)
	           .map(_.property('grade'))
	           .mean()
	           .value();

	console.log(result);    
	           
	assert.equal(result, 90);               
});
