#Programowanie funkcyjne w JavaScripcie
##### Luis Atencio

##Aktualizacja
*Kod został zmodyfikowany i poprawiony ze względu na erratę, kwestie związane z serwisem GitHub i dostosowanie do wersji ES6.*
*Dawny kod jest dostępny w katalogu legacy.*

Ponieważ w kodzie używane są konstrukty z wersji ES6, kod przeznaczony do użytku w przeglądarkach należy
poddać transpilacji za pomocą jednego z następujących narzędzi:

* Babel
* Traceur

Dla użytkowników Node.js - ten kod wymaga wersji: 

node --version > 6.3.1

Pracę z projektami zacznij od wywołania odpowiednich instrukcji:

~~~
npm install
~~~

w celu wczytania wszystkich potrzebnych bibliotek funkcyjnych.

W tym repozytorium znajdziesz:

* Przykładowy kod z rozdziałów (w postaci testów jednostkowych)
* Kod w JavaScripcie przeznaczony dla przeglądarek
* Funkcyjne typy danych takie jak Optional, Either, Maybe, itd.
* Wybrane biblioteki funkcyjne JavaScriptu takie jak lodash.js, streams.js, bacon.js, itd.

##Oto niektóre biblioteki używane w tej książce (aby je pobrać, możesz zastosować instrukcję "npm install")

###QUnit
npm install qunit

###Ramda
npm install ramda

###Lodash
npm install lodash

###RxJS
npm install rxjs


##Uruchamianie testów:
Po zainstalowaniu QUnit możesz uruchomić dowolny plik z testami w następujący sposób: 

~~~
$> node <ścieżka-do-qunit-cli.js> -t <num-rozdziału>/tests.js -c <num-rozdziału>/tests.js
~~~

"ścieżka-do-qunit-cli.js" to node_modules/qunit/bin/cli.js, a "num-rozdziału" to człony od R01 do R08