/**
 * Przykładowy kod z rozdziału 1. 
 *
 * Autor: Luis Atencio
 * Książka: Programowanie funkcyjne w JavaScripcie
 */
QUnit.module( "Rozdział 1." );
"use strict";

QUnit.test(" Prostokąt", function (assert) {

    var rectangle = new Rectangle(10, 20);

    assert.equal(rectangle.getWidth(), 10, 'getWidth');
    assert.equal(rectangle.getHeight(), 20, 'getHeight');
    assert.equal(perimeter(10, 20), 60, 'perimeter');
    assert.equal(area(10, 20), 200, 'area');
});

QUnit.test(" Test funkcji reduce dla tablic", function (assert) {


    var result1 = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9].reduce(function (previousValue, currentValue, index, array) {
        return previousValue + currentValue;
    });

    var result2 = 0;
    var array = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9];
    for (var i = 0; i < array.length; i++) {
        result2 += array[i];
    }

    assert.equal(result1, result2, 'Imperatywny a deklaratywny = ' + result1);
});


QUnit.test(" Silnia", function (assert) {

    // Podejście rekurencyjne
    function fact(n) {
        return n < 2 ? n : n * fact(n - 1);
    }

    // Pętle
    function fact2(n) {
        if (n < 2) {
            return n;
        }
        var res = 1;
        for (var i = n; i > 1; i--) {
            res *= i;
        }
        return res;
    }

    for (var i = 0; i < 10; i++) {
        assert.equal(fact(i), fact2(i), i + ' silnia wynosi ' + fact(i));
    }
});

QUnit.test(" Proste przykłady z rodziału 1.", function (assert) {

    var echo = function (msg) {
        return function () {
            return msg;
        };
    };
    var shoutIt = function (str) {
        return str + '!';
    };

    var shoutHelloWorld = _.compose(shoutIt, echo('witaj, świecie'));
    assert.equal(shoutHelloWorld(), 'witaj, świecie!', 'krzycz witaj, świecie!');
});

QUnit.test(" Funkcja z efektami ubocznymi", function (assert) {

    var students = [];

    function insertUserDbRecord(studentId, className) {
        if (students === null) {
            students = [];
        }
        students.push(studentId, {studentId: className});
        console.log('Dodano studenta do grupy: ' + className);
        return true;
    }

    function isEnrolled(studentId) {
        for (var studentObj in students) {
            if (studentObj.studentId === studentId) {
                return true;
            }
        }
        return false;
    }

    // Ta funkcja generuje efekty uboczne
    function enrollInCourse(studentId, className) {

        if (isEnrolled(studentId)) {
            console.log('Student jest już zapisany na kurs: ' + className);
            return true;
        }
        return insertUserDbRecord(studentId, className);
    }

    var enrolled = enrollInCourse(123, 'FP101 - Wprowadzenie do programowania funkcyjnego');

    assert.ok(enrolled, 'Użytkownik jest zapisany!');
});


QUnit.test(" Kolejność wykonywania ma znaczenie", function (assert) {

    var isInit = false;

    function init() {
        // Inicjowanie programu
        isInit = true;
    }

    function fetchData() {
        if (!isInit) {
            throw 'DataNotInitializedError';
        }
        // Pobieranie danych
    }

    assert.ok(true);
});

QUnit.test(" Funkcja swap - wersja z modyfikacjami", function (assert) {

    var test = [1, 2, 3];

    function swap(items, firstIndex, secondIndex) {
        var temp = items[firstIndex];
        items[firstIndex] = items[secondIndex];
        items[secondIndex] = temp;
    }

    swap(test, 0, 1);
    assert.equal(test[0], 2);
    assert.equal(test[1], 1);
});

QUnit.test(" Funkcja swap zachowująca niemodyfikowalność", function (assert) {

    // Polyfill Array.from
    if (!Array.from) {
        Array.from = (function () {
            var toStr = Object.prototype.toString;
            var isCallable = function (fn) {
                return typeof fn === 'function' || toStr.call(fn) === '[object Function]';
            };
            var toInteger = function (value) {
                var number = Number(value);
                if (isNaN(number)) {
                    return 0;
                }
                if (number === 0 || !isFinite(number)) {
                    return number;
                }
                return (number > 0 ? 1 : -1) * Math.floor(Math.abs(number));
            };
            var maxSafeInteger = Math.pow(2, 53) - 1;
            var toLength = function (value) {
                var len = toInteger(value);
                return Math.min(Math.max(len, 0), maxSafeInteger);
            };

            // Właściwość length metod from jest równa 1.
            return function from(arrayLike/*, mapFn, thisArg */) {
                // 1. Niech C będzie równe this.
                var C = this;

                // 2. Niech items będzie równe ToObject(arrayLike).
                var items = Object(arrayLike);

                // 3. ReturnIfAbrupt(items).
                if (arrayLike == null) {
                    throw new TypeError("Array.from wymaga obiektu podobnego do tablicy - nie null lub undefined");
                }

                // 4. Jeśli mapfn to undefined, odwzorowanie jest fałszywe.
                var mapFn = arguments.length > 1 ? arguments[1] : void undefined;
                var T;
                if (typeof mapFn !== 'undefined') {
                    // 5. else
                    // 5. Jeśli IsCallable(mapfn) ma wartość false, należy zgłosić wyjątek TypeError.
                    if (!isCallable(mapFn)) {
                        throw new TypeError('Array.from: drugi argument musi być funkcją');
                    }

                    // 5. b. Jeśli thisArg jest podany, T to thisArg; w przeciwnym razie T to undefined.
                    if (arguments.length > 2) {
                        T = arguments[2];
                    }
                }

                // 10. lenValue to Get(items, "length").
                // 11. len to ToLength(lenValue).
                var len = toLength(items.length);

                // 13. Jeśli IsConstructor(C) to true, to
                // 13. a. A to wynik wywołania wewnętrznej metody C z listą argumentów z jednym elementem len.
                // 14. a. w przeciwnym razie A to ArrayCreate(len).
                var A = isCallable(C) ? Object(new C(len)) : new Array(len);

                // 16. Niech k będzie równe 0.
                var k = 0;
                // 17. Powtarzanie dopóty, dopóki k < len… (także kroki a - h)
                var kValue;
                while (k < len) {
                    kValue = items[k];
                    if (mapFn) {
                        A[k] = typeof T === 'undefined' ? mapFn(kValue, k) : mapFn.call(T, kValue, k);
                    } else {
                        A[k] = kValue;
                    }
                    k += 1;
                }
                // 18. Niech putStatus będzie równe Put(A, "length", len, true).
                A.length = len;
                // 20. Zwracanie A.
                return A;
            };
        }());
    }

    var test = [1, 2, 3];

    function swap(items, firstIndex, secondIndex) {

        var copy = Array.from(items);
        var temp = copy[firstIndex];
        copy[firstIndex] = copy[secondIndex];
        copy[secondIndex] = temp;
        return copy;
    }

    var swapTest = swap(test, 0, 1);
    assert.equal(test[0], 1);
    assert.equal(test[1], 2);
    assert.equal(swapTest[0], 2);
    assert.equal(swapTest[1], 1);
});

QUnit.test(" Kompozycja funkcji swap, split i join", function (assert) {

    function swap(items, firstIndex, secondIndex) {
        var copy = Array.from(items);
        var temp = copy[firstIndex];
        copy[firstIndex] = copy[secondIndex];
        copy[secondIndex] = temp;
        return copy;
    }

    function splitOnSpace(str) {
        return str.split(/\s+/);
    }

    function joinWithSpace(arr) {
        return arr.join(' ');
    }

    var swap01 = _.partial(swap, _, 0, 1);
    var reverseName = _.compose(joinWithSpace, swap01, splitOnSpace);

    assert.equal(reverseName('Luis Atencio'), 'Atencio Luis');

    var number = _.compose(Math.round, parseFloat);

    assert.equal(number('2.5'), 3);

    function add(a, b) {
        return a + b;
    }

    var result = add(number(2.5), number(3.5));
    assert.equal(result, 7);

});


QUnit.test(" Kompozycja funkcji", function (assert) {

    function stripNonAlpha(str) {
        return str.replace(/[^a-z]*/ig, '');
    }

    var stripEncode = _.compose(btoa, stripNonAlpha);

    assert.equal(stripEncode('#$#$^&ABC&*&*&'), 'QUJD', true);
});


QUnit.test(" Kompozycja funkcji", function (assert) {

    function stripNonAlpha(str) {
        return str.replace(/[^a-z]*/ig, '');
    }

    var stripEncode = _.compose(btoa, stripNonAlpha);

    assert.equal(stripEncode('#$#$^&ABC&*&*&'), 'QUJD', true);
});

QUnit.test(" Objętość i powierzchnia", function (assert) {

    function areaSquare(a) {
        return a * a;
    }

    function volumeCube(areaSquare, a) {
        return areaSquare * a;
    }

    assert.equal(volumeCube(4, 2), 2 * areaSquare(2), 'Objętość i powierzchnia');
});


QUnit.test(" Filtrowanie", function (assert) {

    var result = [[], null, undefined, {}, 'String', 1, false].filter(_.isObject);

    assert.equal(result.length, 2, 'Odfiltrowane obiekty');
});

QUnit.test(" Pobierz i powtórz", function (assert) {


    var naturalNumbers = Stream.range(); // naturalNumbers to teraz 1, 2, 3, ...

    var evenNumbers = naturalNumbers.map(function (x) {
        return 2 * x;
    });
    // evenNumbers to teraz 2, 4, 6, ...

    var oddNumbers = naturalNumbers.filter(function (x) {
        return x % 2 != 0;
    }); // oddNumbers to teraz 1, 3, 5, ...

    evenNumbers.take(3).print(); // Wyświetla 2, 4, 6
    oddNumbers.take(3).print(); // Wyświetla 1, 3, 5

    assert.ok(true);
});

QUnit.test(" Przetwarzanie danych", function (assert) {

    var luis = new Person().setFirstname('Luis').setAddress('Ft. Lauderdale', 'USA');

    luis.addFriend(new Person()
        .setFirstname('Carlos')
        .setAddress('Ft. Lauderdale', 'USA'));

    luis.addFriend(new Person()
        .setFirstname('Carlos')
        .setAddress('Weston', 'USA'));

    luis.addFriend(new Person()
        .setFirstname('Ana')
        .setAddress('Ft. Lauderdale', 'USA'));

    var friendsInUs = luis.getFriendsBy(function (f) {
        return f.getAddress().getCountry() === 'USA';
    });

    assert.equal(friendsInUs.length, 3);

    var friendsInFtLauder = luis.getFriendsBy(function (f) {
        return f.getAddress().getCity() === 'Ft. Lauderdale';
    });

    assert.equal(friendsInFtLauder.length, 2);

    var friendsInLuisCity = luis.getFriendsBy(function (f) {
        return f.getAddress().getCity() === this.getAddress().getCity();
    });

    assert.equal(friendsInLuisCity.length, 2);
});


QUnit.test(" Przetwarzanie danych - niefunkcyjnie", function (assert) {

    function Person2(name, country) {
        this.name = name;
        this.country = country;
        this.friends = [];
    }

    Person2.prototype.addFriend = function (f) {
        this.friends.push(f);
    };
    Person2.prototype.getCountry = function () {
        return this.country;
    };
    Person2.prototype.getFriendsInUs = function () {
        var usFriends = [];
        for (var idx in this.friends) {
            var friend = this.friends[idx];
            if (friend.country === 'USA') {
                usFriends.push(friend);
            }
        }
        return usFriends;
    };
    Person2.prototype.getFriendsNotInUs = function () {
        var nonUsFriends = [];
        for (var idx in this.friends) {
            var friend = this.friends[idx];
            if (friend.country !== 'USA') {
                nonUsFriends.push(friend);
            }
        }
        return nonUsFriends;
    };

    var luis = new Person2('Luis', 'USA');
    luis.addFriend(new Person2('Carlos', 'USA'));
    luis.addFriend(new Person2('Ana', 'USA'));
    luis.addFriend(new Person2('Nicole', 'Wenezuela'));

    var friendsInUs = luis.getFriendsInUs();
    var friendsNotInUs = luis.getFriendsNotInUs();

    assert.equal(friendsInUs.length, 2);
    assert.equal(friendsNotInUs.length, 1);
});

QUnit.test(" Rekurencja a pętle", function (assert) {

    var foo = _.rest(['a']);
    assert.equal(foo.length, 0);

    var arr = ['Arizona', 'Mississippi', 'Florida', 'California', 'Ohio'];

    function longest(arr) {

        var longest = '';
        for (var i = 0; i < arr.length; i++) {
            if (arr[i].length > longest.length) {
                longest = arr[i];
            }
        }
        return longest;
    }

    assert.equal(longest(arr), 'Mississippi');


    var longest2 = (function longest2(str, arr) {

        return _.isEmpty(arr) ? str :
            longest2(_.first(arr).length >= str.length ? _.first(arr) : str,
                _.rest(arr));
    }).bind(null, '');

    assert.equal(longest2(arr), 'Mississippi');
});





QUnit.test(" Studenci zapisani na więcej niż jedne zajęcia", function (assert) {

    var roster = [{name: 'Alonzo', enrolled: 3, grade: 99},
        {name: 'Rosser', enrolled: 1, grade: 80},
        {name: 'Turing', enrolled: 2, grade: 89}];

    var totalGrades = 0;
    var totalStudentsFound = 0;
    for (var i = 0; i < roster.length; i++) {
        var student = roster[i];
        if (student !== null) {
            if (student.enrolled > 1) {
                totalGrades += student.grade;
                totalStudentsFound++;
            }
        }
    }
    var average = Math.floor(totalGrades / totalStudentsFound);
    assert.equal(average, 94);


    function getStudents(roster) {
        return roster.filter(function (student) {
            return student.enrolled > 1
        })
            .map(function (student) {
            return student.grade;
        });
    }

    function calcAverage(grades) {
        return grades.reduce(function (total, current) {
                return total + current
            }) / grades.length;
    }

    _.mixin({
        'average': calcAverage
    });

    var average2 = _.compose(Math.floor, calcAverage, getStudents);
    assert.equal(average2(roster), average);

    var average3 = function(roster) {
        return _.chain(roster).filter(function (student) {
                return student.enrolled > 1
            }).pluck('grade').average().value();
    };
    assert.equal(average3(roster), average);
});



//QUnit.test(" Funkcyjna wersja getCountry", function (assert) {
//
//    var princeton = new School('Princeton', new Address2('London','Anglia'));
//    var student = new Student('Alan', 'Turing', princeton);
//
//    var getCountry = function(student) {
//        return Optional.of(student).map('getSchool').map('getAddress').map('getCountry').getOrElse('Unknown');
//    };
//
//    assert.equal(getCountry(student), 'Anglia');
//
//    // Imperative version
//    //function getCountry(student) {
//    //    var school = student.getSchool();
//    //    if(school !== null) {
//    //        var addr = school.getAddress();
//    //        if(addr !== null) {
//    //            var country = addr.getCountry();
//    //            return country;
//    //        }
//    //        return null;
//    //    }
//    //    return null;
//    //}
//});

QUnit.test(" Funkcyjna wersja getCountry", function (assert) {

    var grades = [100, 80, 90];

    function append(grades, newGrade) {
        var newGrades = grades.slice(0);
        newGrades.push(newGrade);
        return newGrades;
    }

    assert.equal(append(grades, 95).length, 4);
    assert.equal(grades.length, 3);

    function addAndcomputeAverageGrade1(grades, newGrade) {
        var totalGrades = 0;
        var validNumGrades = 0;
        grades.push(newGrade);
        for(var i = 0; i < grades.length; i++) {
            if(grades[i] !== null || grades[i] !== undefined) {
                totalGrades+= grades[i];
                validNumGrades ++;
            }
        }
        var newAverage = totalGrades / validNumGrades;
        return Math.round(newAverage);
    }

    function average(grades) {
        return grades.reduce(function (total, current) { return total + current; })
            / grades.length;

    }

    var addAndcomputeAverageGrade2 = R.compose(Math.round, average, append);

    assert.equal(addAndcomputeAverageGrade1(grades, 100), 93);

    grades = [100, 80, 90];
    assert.equal(addAndcomputeAverageGrade2(grades, 100), 93);
});
