/**
 * Klasa monady IO 
 * Autor: Luis Atencio
 */
const _ = require('lodash');

exports.IO = class IO {

  constructor(effect) {
    if (!_.isFunction(effect)) {
      throw 'Użytkowanie monady IO: wymagane podanie funkcji';
    }  
    this.effect = effect;
  }

  static of(a) {    
    return new exports.IO( () => a );
  }
  
  static from(fn) {
    return new exports.IO(fn);
  }
  
  map(fn) {    
    var self = this;
    return new exports.IO(function () {
      return fn(self.effect());
    });
  }

   chain(fn) {
    return fn(this.effect());
  }
  
  run() {    
    return this.effect();
  }
};