/**
  Listingi z rozdziału 8.
  Ten plik zawiera testy dotyczące wszystkich podrozdziałów z tego rozdziału.
  Autor: Luis Atencio
*/

"use strict";

QUnit.module('Rozdział 8.');

const Student = require('../model/Student.js').Student;
const Address = require('../model/Address.js').Address;
const Person = require('../model/Person.js').Person;

const IO = require('../model/monad/IO.js').IO;

const R = require('ramda');
const Rx = require('rxjs/Rx');

// Funkcje pomocnicze symulujące wywołania AJAX-owe
const getJSON = function (fakeUrl) {
	console.log('Pobieranie danych na podstawie adresu URL: ' + fakeUrl);
	return new Promise(function(resolve, reject) {
			
		// Dane studentów
		if(fakeUrl.indexOf('students') >= 0) {
			var s1 = new Student('111-11-1111', 'Haskell', 'Curry', 'Princeton', 1900, new Address('USA'));	
			var s2 = new Student('222-22-2222', 'Barkley', 'Rosser', 'Princeton', 1907, new Address('Grecja'));
			var s3 = new Student('333-33-3333', 'John', 'von Neumann', 'Princeton', 1903, new Address('Węgry'));
			var s4 = new Student('444-44-4444', 'Alonzo', 'Church', 'Princeton', 1903, new Address('USA'));

			resolve([s2, s3, s4, s1]);	
		}
		// Fikcyjne liczby punktów studentów
		else {
			resolve([80, 70, 20, 40, 99, 100]);	
		}
	});
};

QUnit.test("Generator 1.", function (assert) {

    function *addGenerator() {
        var i = 0;
        while (true) {
            i += yield i;
        }
    }
    let adder = addGenerator();
    assert.equal(adder.next().value, 0)
    assert.equal(adder.next(5).value, 5);
});

QUnit.test("Generator 2.", function (assert) {

    function *range(start, finish) {
        for(let i = start; i < finish; i++) {
            yield i;
        }
    }

    let r = range(0, Number.POSITIVE_INFINITY);
    assert.equal(r.next().value, 0)
    assert.equal(r.next().value, 1);
    assert.equal(r.next().value, 2);
});


QUnit.test("Pobieranie danych studentów za pomocą wywołań asynchronicznych", function (assert) {

	const fork = (join, func1, func2) => (val) => join(func1(val), func2(val));

	const csv = arr => arr.join(',');

    getJSON('/students')
		.then(R.tap(() => console.log('Ukrywanie kontrolki spinner')))  // <- Symulowanie ukrywania kontrolki spinner na stronie
		.then(R.filter(s => s.address.country === 'USA'))		
		.then(R.sortBy(R.prop('ssn')))		
		.then(R.map(student => {
			return getJSON('/grades?ssn=' + student.ssn)
				.then(R.compose(Math.ceil, fork(R.divide, R.sum, R.length)))												
				.then(grade => 
					IO.of(R.merge({'_grade': grade}, student))	
						//.map(console.log)				
						.map(R.props(['_ssn', '_firstname', '_lastname', '_grade']))
						.map(csv)						
						.map(console.log).run())  // <- Wyświetlanie wyników w oknie konsoli								
				}))			
		.catch(function (error) {
			console.log('Wystąpił błąd: ' + error.message);
		});	
	expect(0); // Ten kod po uruchomieniu wyświetla dane wyjściowe na ekranie za pomocą monady IO, dlatego w funkcji 
	// expect nie są oczekiwane żadne wyniki
});


QUnit.test("Pobieranie danych studentów za pomocą wywołań asynchronicznych", function (assert) {
	function range(start, end) {
		return {
			[Symbol.iterator]() {
				return this;
			},
			
			next() {
				if(start < end) {
					return { value: start++, done:false };
				}	
			return { done: true, value:end };
			}
		};
	}

	let res = [];
	for(let num of range(0,5)) {
		console.log(num);
		res.push(num);
	}
	assert.deepEqual(res, [0,1,2,3,4]);
});


QUnit.test("Test biblioteki Rx", function (assert) {

	let res = [];
	Rx.Observable.range(1, 3)
		.subscribe(
			x => { 
				console.log(`Next: ${x}`)
				res.push(x);
			},
			err => console.log(`Błąd: ${err}`),
			() => console.log('Gotowe')
		);
	assert.deepEqual(res, [1,2,3]);	
});



QUnit.test("Drugi test biblioteki Rx", function (assert) {

	let res = [];
	Rx.Observable.of(1,2,3,4,5)
		.filter(x => x%2 !== 0)
		.map(x => x * x)
		.subscribe(x => {
			console.log(`Next: ${x}`)
			res.push(x);
		}
	);
	assert.deepEqual(res, [1,9,25]);	
});


