
const DB_NAME = 'students';
var open = function() {
    const version = 2;
    return new Promise(function(resolve, reject) {
        // Otwieranie nowej bazy danych
        var request = indexedDB.open("studentData", version);
        var db;

        // Obsługa zdarzenia onupgradeneeded
        // Ta funkcja jest wywoływana, gdy baza jest nowa lub po zmianie wersji
        request.onupgradeneeded = function(e) {
            db = e.target.result;
            e.target.transaction.onerror = indexedDB.onerror;

            // Usuwanie bazy, jeśli już istnieje
            if(db.objectStoreNames.contains(DB_NAME)) {
                db.deleteObjectStore(DB_NAME);
            }
            // Tworzenie nowej bazy z użyciem określonego klucza
            var store = db.createObjectStore("students", {keyPath: "ssn", autoIncrement: true});
        };

        // Po udanym otwarciu bazy
        request.onsuccess = function(e) {
            db = e.target.result;
            resolve(db);
        };

        // Jeśli z jakiegoś powodu bazy nie można było otworzyć
        request.onerror = function(e) {
            reject(Error("Nie można otworzyć bazy"));
        };
    });
};

var find = function (db, studentId) {
    const trans = db.transaction(['students'], 'readonly');
    const store = trans.objectStore('students');
    return new Promise(function(resolve, reject) {
        var request = store.get(studentId);

        request.onerror = function() {
            reject(new Error('Studenta nie znaleziono!'));
        };
        request.onsuccess = function() {
            resolve(request.result);
        };
    });
};

var getAllStudents = function(db) {
    var studentArr = [];

	// Tworzenie obiektu transakcji na potrzeby operacji odczytu i zapisu
    var trans = db.transaction([DB_NAME], "readwrite");

	// Pobieranie referencji do bazy danych
    var store = trans.objectStore(DB_NAME);

    // Opakowywanie całej logiki w obietnicę
    return new Promise(function(resolve, reject) {
        // Otwieranie kursora w celu pobierania elementów od dolnego ograniczenia
        //var keyRange = IDBKeyRange.lowerBound(0);
        var cursorRequest = store.openCursor();

        // Wywołanie zwrotne dla powodzenia
        cursorRequest.onsuccess = function(e) {
            var result = e.target.result;

            // Przetwarzanie obietnicy, gdy wynik jest pusty
            if(result === null || result === undefined) {

                resolve({
                    'db': db,
                    'data': studentArr
                });
            }
            // Umieszczanie wyniku na liście
            else{
                studentArr.push(result.value);
                result.continue();
            }
        };

        //Wywołanie zwrotne dla błędu
        cursorRequest.onerror = function(e){
            reject("Nie można pobrać elementów z bazy");
        };
    });
};

var addStudent = function(db, firstname, lastname, ssn) {
    // Tworzneie obiektu transakcji na potrzeby operacji w/w
    var trans = db.transaction([DB_NAME], "readwrite");
    var store = trans.objectStore(DB_NAME);

    //Opakowywanie logiki w obietnicę
    return new Promise(function(resolve, reject){
        //Przesyłanie żądania dodania elementu
        var request = store.add({
            ssn: ssn, firstname: firstname, lastname: lastname
        });

        //Wywołanie zwrotne dla powodzenia
        request.onsuccess = function(e) {
            resolve(db);
        };

        //Wywołanie zwrotne dla błędu
        request.onerror = function(e) {
            console.log(e.value);
            reject("Nie udało się dodać przekazanego elementu");
        };
    });
};

var deleteStudent = function(db, id) {
    return new Promise(function(resolve, reject){
        var trans = db.transaction([DB_NAME], "readwrite");
        var store = trans.objectStore(DB_NAME);
        var request = store.delete(id);

        request.onsuccess = function(e) {
            resolve(true);
        };

        request.onerror = function(e) {
            console.log(e);
            reject("Nie można usunąć elementu");
        };
    });
};