/**
 * Niestandardowa monada Maybe zgodna z wersją ES6 używana w książce Programowanie funkcyjne w JavaScripcie
 * Autor: Luis Atencio
 */ 
exports.Maybe = class Maybe {
	static just(a) {
		return new exports.Just(a);
	}
	static nothing() {
		return new exports.Nothing();
	}
	static fromNullable(a) {
		return a !== null ? Maybe.just(a) : Maybe.nothing();
	}
	static of(a) {
		return Maybe.just(a);
	}
	get isNothing() {
		return false;
	}
	get isJust() {
		return false;
	}
};


// Klasa pochodna Just oznacza obecność wartości
exports.Just = class Just extends exports.Maybe {
	constructor(value) {
		super();
		this._value = value;
	}

	get value() {
		return this._value;
	}
	
	map(f) {
		return exports.Maybe.fromNullable(f(this._value));
	}

	chain(f) {
		return f(this._value);
	}

	getOrElse() {
		return this._value;
	}

	filter(f) {
		exports.Maybe.fromNullable(f(this._value) ? this._value : null);
	}

	get isJust() {
		return true;
	}

	toString () {
		return `Maybe.Just(${this._value})`;
	}
};

// Klasa pochodna Nothing oznacza brak wartości
exports.Nothing = class Nothing extends exports.Maybe {
	map(f) {
		return this;
	}
	
	chain(f) {
		return this;
	}

	get value() {
		throw new TypeError("Nie można pobrać wartości obiektu typu Nothing.");
	}

	getOrElse(other) {
		return other;
	}

	filter() {
		return this._value;
	}

	get isNothing() {
		return true;
	}	

	toString() {
		return 'Maybe.Nothing';
	}
};