/**
  Listingi z rozdziału 6. Nie są to standardowe testy jednostkowe, tylko testu JSCheck.
  Platformą uruchamiania testów jest tu QUnit.
  Autor: Luis Atencio
*/
"use strict";

const R = require('ramda');
const JSC = require('jscheck');
const Either = require('../model/monad/Either.js').Either;

QUnit.test('Run JSCheck', function (assert) {
	
	// Testowane funkcje
	const fork = (join, func1, func2) => (val) => join(func1(val), func2(val));

	const toLetterGrade = (grade) => {
			if (grade >= 90) return 'A';
			if (grade >= 80) return 'B';
			if (grade >= 70) return 'C';
			if (grade >= 60) return 'D';
			return 'F';
		};

	const computeAverageGrade =
		R.compose(toLetterGrade, fork (R.divide, R.sum, R.length));


	JSC.clear();
	JSC.on_report((str) => console.log(str));
	JSC.test(
		'Wyznaczanie ocen na podstawie średniej',
		function (verdict, grades, grade) {
			return verdict(computeAverageGrade(grades) === grade);
		},
		[
			JSC.array(JSC.integer(20), JSC.number(90,100)),
			'A'
		],
		function (grades, grade) {
			return 'Testy oceny ' + grade + ' dla liczby punktów: ' + grades;
		}
	);
	expect(0); 
});

/**
 * Generuje poprawny numer SSN (z myślnikami)
 * @param param1 Numer obszaru -> JSC.integer(100, 999)
 * @param param2 Numer grupy -> JSC.integer(10, 99)
 * @param param3 Numer sekwencyjny -> JSC.integer(1000,9999)
 * @returns {Function} Specyfikator
*/
JSC.SSN = function (param1, param2, param3) {
	return function generator() {
		const part1 = typeof param1 === 'function' ? param1(): param1;
		const part2 = typeof param2 === 'function' ? param2(): param2;
		const part3 = typeof param3 === 'function' ? param3(): param3;
		return [part1 , part2, part3].join('-');
	};
};

QUnit.test('JSCheck: niestandardowy specyfikator numeru SSN', function (assert) {

	// Testowane funkcje
	const validLength = (len, str) => str.length === len;

	const find = R.curry((db, id) => db.find(id));
	
	const checkLengthSsn = ssn => {		
		return Either.of(ssn)
			.filter(R.partial(validLength, [9]));
	};

	JSC.clear();
	
	JSC.on_report((report) => console.log('Report'+ str));
	
	JSC.on_pass((object) => assert.ok(object.pass));
	
	JSC.on_fail((object) =>
		assert.ok(object.pass || object.args.length === 9, 'Nieudany test: ' + object.args));

	JSC.test(
		'checkLengthSsn',
		function (verdict, ssn) {
			return verdict(checkLengthSsn(ssn));
		},
		[
			JSC.SSN(JSC.integer(100, 999), JSC.integer(10, 99),
			JSC.integer(1000,9999))
		],
		function (ssn) {
			return 'Sprawdzanie niestandardowego numeru SSN: ' + ssn;
		}
	);

	expect(0); 
});
