<?php
// Prosty skrypt zwracający dane o studentach
// Rozdział 8.
// Luis Atencio
// php -S localhost:8000 -t ~/Code/JS/functional-programming-js/src/ch-listings

header('Content-Type: application/json');
header('Access-Control-Allow-Origin: *');

if (preg_match('/\.(?:png|jpg|jpeg|gif)$/', $_SERVER["REQUEST_URI"])) {
    return false;    // Udostępnia żądany zasób bez przetwarzania go.
}
else {
    $data = [];
    if($_SERVER["REQUEST_URI"] == '/students') {
        $s1 = new Student('Haskell', 'Curry', '444-44-4444');
        $s1->address = new Address('USA');

        $s2 = new Student('Alan', 'Turing', '555-55-5555');
        $s2->address = new Address('Anglia');

        $s3 = new Student('Alonzo', 'Church', '666-66-6666');
        $s3->address = new Address('USA');

        $data[] = $s1;
        $data[] = $s2;
        $data[] = $s3;
    }
    else {
        switch($_GET["ssn"]) {
           case "444-44-4444":
                $g1 = [80, 90, 100];
                $data = $g1;
            break;
            case "555-55-5555":
                $g1 = [90, 91, 89];
                $data = $g1;
            break;
            case "666-66-6666":
                $g1 = [95, 79, 89];
                $data = $g1;
            break;
        }
    }
    echo json_encode($data);
}

class Student {
    public $firstname;
    public $lastname;
    public $ssn;
    public $address;

    function __construct($firstname, $lastname, $ssn) {
        $this->firstname = $firstname;
        $this->lastname = $lastname;
        $this->ssn = $ssn;
    }
}

class Address {
    public $country;

    function __construct($country = 'USA') {
        $this->country = $country;
    }
}
?>