import javax.mail.*;
import javax.mail.internet.InternetAddress;
import java.util.Properties;

public class MailSender
{
    private HostInformation host;
    private Roster roster;

    public MailSender (HostInformation host, Roster roster) {
        this.host = host;
        this.roster = roster;
    }

    public void sendMessage (Message message) throws Exception {
        Transport transport
            = getSMTPSession ().getTransport ("smtp");
        transport.connect (host.smtpHost,
                           host.smtpUser, host.smtpPassword);
        transport.sendMessage (message, roster.getAddresses ());
    }

    private Session getSMTPSession () {
        Properties props = new Properties ();
        props.put ("mail.smtp.host", host.smtpHost);
        return Session.getDefaultInstance (props, null);
    }
}
