<?php
error_reporting(E_ERROR);
session_start();
require_once("includes.php");

$filters = array(  
    'openid_ax_value_email' => FILTER_SANITIZE_ENCODED,
    'openid_identity' => FILTER_SANITIZE_ENCODED,
    'openid_oauth_request_token' => FILTER_SANITIZE_ENCODED
);
$attributes = filter_var_array($_REQUEST, $filters);

$consumer = get_consumer();

// kończy proces uwierzytelniania openid przy użyciu katalogu głównego aplikacji
$return_url = sprintf("http://%s%s/complete.php", $_SERVER['SERVER_NAME'], dirname($_SERVER['PHP_SELF']));
$response = $consumer->complete($return_url);

// stan odpowiedzi - uwierzytelnianie zostało anulowane
if ($response->status == Auth_OpenID_CANCEL) {
    $response_state = 'Uwierzytelnianie OpenID zostało anulowane';
// stan odpowiedzi - uwierzytelnianie zakończyło się niepowodzeniem
} else if ($response->status == Auth_OpenID_FAILURE) {
    $response_state = "Uwierzytelnianie OpenID zakończyło się niepowodzeniem: " . $response->message;
// stan odpowiedzi - uwierzytelnianie zakończyło się pomyślnie
} else if ($response->status == Auth_OpenID_SUCCESS) {
    //get the identity url and capture success message
    $openid = htmlentities($response->getDisplayIdentifier());
    $response_state = sprintf('Uwierzytelnianie OpenID zakończyło się pomyślnie: <a href="%s">%s</a>', $openid, $openid);

    if ($response->endpoint->canonicalID){
        $response_state .= '<br />Dodano XRI CanonicalID: ' . htmlentities($response->endpoint->canonicalID);
    }

    // uzyskuje wartości zwrócone przez rozszerzenie attribute exchange
    $response_ax = new Auth_OpenID_AX_FetchResponse();
    $ax_return = $response_ax->fromSuccessResponse($response);
    foreach ($ax_return->data as $item => $value){
        $response_state .= "<br />Rozszerznie AX zwróciło element <b>$item</b> z wartością: <b>{$value[0]}</b>";
    }
    
    // jeśli wstępnie zaakceptowany token żądania jest dostępny, rozpoczyna proces
    // uwierzytelniania OAuth od kroku 4.
    // patrz http://developer.yahoo.com/oauth/guide/request-token.html
    if(isset($attributes['openid_oauth_request_token'])){
        $consumer = new OAuthConsumer(CONSUMER_KEY, CONSUMER_SECRET, APP_ID);
        $sig_method = new OAuthSignatureMethod_HMAC_SHA1();
        
        // ręcznie generuje obiekt tokenu żądania
        $req_token = new stdclass();
        $req_token->key = $attributes['openid_oauth_request_token'];
        $req_token->secret = '';
        
        // generuje obiekt tokenu dostępu
        $acc_req = OAuthRequest::from_consumer_and_token($consumer, $req_token, "GET", $oauth_access_token_endpoint, array());
        $acc_req->sign_request($sig_method, $consumer, $req_token);
        $access_ret = run_curl($acc_req->to_url(), 'GET');
        
        // jeśli udało się pobrać token dostępu, musimy wyodrębnić wartości oauth_token i oauth_token_secret,
        // aby na ich podstawie skonstruować obiekt konsumenta dostępu
        $access_token = array();
        parse_str($access_ret, $access_token);
        $access_consumer = new OAuthConsumer($access_token['oauth_token'], $access_token['oauth_token_secret'], NULL);
        
        // konstruuje adres URL żądania GET profilu
        $guid = $access_token['xoauth_yahoo_guid'];
        $url = sprintf("http://%s/v1/user/%s/profile",
            'social.yahooapis.com', 
            $guid 
        );
        
        // konstruje i podpisuje żądanie
        $request = OAuthRequest::from_consumer_and_token($consumer, 
            $access_consumer, 
            'GET',
            $url, 
            array());
        $request->sign_request(new OAuthSignatureMethod_HMAC_SHA1(),
            $consumer, 
            $access_consumer
        );
        
        // wysyła żądanie GET
        $resp = run_curl($request->to_url(), 'GET');
        
        // w trybie diagnostycznym wyświetla podpisy i nagłówki procesu OpenID / OAuth
        if ($debug){
            $debug_out = array('OpenID Response' => $response_state,
                               'Access token'    => $access_token,
                               'GET URL'         => $url,
                               'GET response'    => htmlentities($resp));
            
            print_r($debug_out);
        }
    }
}
?>