import os
import cgi
import sys
import Cookie
import urllib
import oauth.oauth as oauth
import common

'''
' Class: Obsługa notacji kropki
' Description: Dodaje obsługę notacji kropki do przekazanego słownika
'''
class dotdict(dict):
    def __getattr__(self, attr):
        return self.get(attr, None)
    __setattr__= dict.__setitem__
    __delattr__= dict.__delitem__

'''
' Function: Main
' Description: 
'''
def main():
    # tworzy nowy obiekt SmartCookie, aby wyodrębnić token żądania
    cookie = Cookie.SmartCookie()
    
    # jeśli plik cookie jest dostępny, jego zawartość jest ładowana
    if os.environ.has_key('HTTP_COOKIE'):
        cookie.load(os.environ['HTTP_COOKIE'])
        
        # jeśli plik cookie tokenu żądania jest dostępny, kod ładuje i przetwarza jego zawartość
        if cookie.has_key('request_token'):
            request_token = cookie.get('request_token').value
            rt_params = cgi.parse_qs(request_token)
            
            # wyodrębnienie parametrów łańcucha zapytania do słownika
            qs_params = {}
            string_split = [s for s in os.environ['QUERY_STRING'].split('&') if s]
            for item in string_split:
                key,value = item.split('=')
                qs_params[key] = value
            
            # tworzy bazowy obiekt konsumenta i obiekt metody podpisywania żądań
            base_consumer = oauth.OAuthConsumer(common.consumer_key, common.consumer_secret)
            signature_method_hmac_sha1 = oauth.OAuthSignatureMethod_HMAC_SHA1()
            
            # konstruuje słownik złożony z tokenu żądania i klucza tajnego, które zostaną
            # wymienione na token dostępu
            req_token = dotdict({'key': rt_params['token'][0], 'secret': rt_params['token_secret'][0]})
        
            # tworzy i podpisuje token żądania, który zostanie wymieniony na token dostępu
            oauth_request = oauth.OAuthRequest.from_consumer_and_token(base_consumer, token=req_token, verifier=qs_params['oauth_verifier'], http_url=common.oauth_access_token_endpoint)
            oauth_request.sign_request(signature_method_hmac_sha1, base_consumer, req_token)
            
            # uzyskuje token żądania w formie łańcucha i obiektów słownika
            token_read = urllib.urlopen(oauth_request.to_url())
            token_string = token_read.read()
            token_params = cgi.parse_qs(token_string)
            
            # tworzy obiekt tokenu dostępu (na podstawie łańcucha tokenu dostępu)
            access_token = oauth.OAuthToken.from_string(token_string)
            
            # tworzy adres URL serwerów Yahoo!; adres umożliwi dostęp do profilu użytkownika
            guid = token_params['xoauth_yahoo_guid'][0]
            url = 'http://%s/v1/user/%s/profile' % ('social.yahooapis.com', guid)
            
            # tworzy nowe żądanie OAuth i podpisuje je przy użyciu algorytmu HMAC-SHA1, aby uzyskać
            # profil autoryzowanego użytkownika
            oauth_request = oauth.OAuthRequest.from_consumer_and_token(base_consumer, token=access_token, http_method='GET', http_url=url)
            oauth_request.sign_request(signature_method_hmac_sha1, base_consumer, access_token)
            
            # wysyła żądanie pobrania profilu użytkownika
            profile_read = urllib.urlopen(oauth_request.to_url())
            profile_string = profile_read.read()
            print 'Content-Type: text/plain'
            print ''
            print profile_string
        else:
            # jeśli plik cookie tokenu żądania nie jest dostępny, skrypt kończy pracę
            print 'Nie znaleziono pliku cookie tokenu żądania - wyjście'
            sys.exit()
    else:
        # jeśli pliki cookie nie są dostępne, skrypt kończy pracę
        print 'Nie znaleziono pliku cookie tokenu żądania - wyjście'
        sys.exit()
    
if __name__ == '__main__':
    main()