<?php
require_once "OAuth.php";       // biblioteka OAuth
require_once "common.php";      // wspólne funkcje i zmienne

// inicjalizuje konsumenta
$consumer = new OAuthConsumer($key, $secret, NULL);

// przygotowanie do pobrania tokenu żądania
$sig_method = new OAuthSignatureMethod_HMAC_SHA1();
$parsed = parse_url($request_token_endpoint);
$params = array('oauth_callback' => $base_url);

// podpisanie żądania i pobranie tokenu żądania
$req_req = OAuthRequest::from_consumer_and_token($consumer, NULL, "GET", $request_token_endpoint, $params);
$req_req->sign_request($sig_method, $consumer, NULL);
$req_token = run_curl($req_req->to_url(), 'GET');

// jeśli udało się pobrać token żądania, odpowiedź powinna zawierać parametry oauth_token i oauth_token_secret
parse_str($req_token, $tokens);
$oauth_token = $tokens['oauth_token'];
$oauth_token_secret = $tokens['oauth_token_secret'];

// zapisuje klucz i szczegóły tokenu w pliku cookie, aby przekazać je do następnego etapu
setcookie("requestToken", "key=$key&token=$oauth_token&token_secret=$oauth_token_secret");
			  
// generuje adres URL uwierzytelniania i przekierowuje użytkownika
$auth_url = $authorize_endpoint . "?oauth_token=$oauth_token";
header("Location: $auth_url");
?>