<?php
require_once("OAuth.php");
 
class buildSignatureMethod extends OAuthSignatureMethod_RSA_SHA1 {
    public function fetch_public_cert(&$request) {
        return file_get_contents("http://www.fmodules.com/public080813.crt");
    }
}
 
// konstruuje żądanie na podstawie parametrów POST i GET
$request = OAuthRequest::from_request(null, null, array_merge($_GET, $_POST));
 
// tworzy nową metodę podpisu na podstawie utworzonej klasy i certyfikatu klucza publicznego
$signature_method = new buildSignatureMethod();
 
// sprawdza podpis
@$signature_valid = $signature_method->check_signature($request, null, null, $_GET["oauth_signature"]);

$response = array(); 
if ($signature_valid) {
    // sprawdza podpisane żądanie i wysyła komunikat o pomyślnej weryfikacji
    $response['validation'] = "valid";
} else {
    // sprawdza podpisane żądanie i wysyła komunikat o niepowodzeniu weryfikacji
    $response['validation'] = "invalid";
}
 
// wyświetla obiekt odpowiedzi
print(json_encode($response));
?>

