<?php
/* Copyright 2011 Jonathan LeBlanc
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * Class: Subskrybent
 * Description: Umożliwia dodawanie/usuwanie subskrypcji kanałów huba
 */
class Subscriber{
    private $regex_url = '|^https?://|i';       // prosty mechanizm weryfikacji adresu URL
    private $hub = '';                          // adres URL huba
    private $callback = '';                     // adres URL wywołania zwrotnego
    
    // Konstruktor zapisujący adresy URL huba i wywołań zwrotnych dla danego subskrybenta
    public function __construct($hub, $callback){
        if (preg_match($this->regex_url, $hub)){ $this->hub = $hub; }
        else{ throw new Exception('Nieprawidłowy adres URL huba'); }
        
        if (preg_match($this->regex_url, $callback)){ $this->callback = $callback; }
        else{ throw new Exception('Nieprawidłowy adres URL wywołań zwrotnych'); }
    }
    
    // Wysyła żądanie dodania subskrypcji kanału
    public function subscribe($feed){
        return $this->change_subscription('subscribe', $feed);
    }
    
    // Wysyła żądanie usunięcia subskrypcji kanału
    public function unsubscribe($feed){
        return $this->change_subscription('unsubscribe', $feed);
    }
    
    // Wysyła do huba żądanie dodania lub usunięcia subskrypcji
    public function change_subscription($mode='subscribe', $feed){
        // Sprawdza, czy przekazany adres URL kanału jest prawidłowy
        if (preg_match($this->regex_url, $feed)){
            // Ustawia łańcuch żądania POST dodania lub usunięcia subskrypcji
            $post_string = "hub.mode=$mode&hub.callback={$this->callback}&hub.verify=async&hub.topic=$feed";
            
            // Ustawia żąanie cURL
            $ch = curl_init($this->hub);
            $options = array(
                CURLOPT_HEADER => true,
                CURLINFO_HEADER_OUT => true,
                CURLOPT_VERBOSE => true,
                CURLOPT_RETURNTRANSFER => true,
                CURLOPT_POSTFIELDS => $post_string,
                CURLOPT_CUSTOMREQUEST => 'POST'
            );
            curl_setopt_array($ch, $options);
            
            // Wysyła żądanie do huba
            $response = curl_exec($ch);
            curl_close($ch);
            
            // Zwraca odpowiedź
            return $response;
        } else {
            throw new Exception('Nieprawidłowy adres URL kanału');
        }
    }
}
?>