import urllib
import re
from BeautifulSoup import BeautifulSoup

"""
" Class: Parser Open Graph 
" Description: Wykonuje analizę składniową dokumentu HTML, aby uzyskać i
"              zapisać znaczniki Open Graph zawarte w metadanych
" Author: Jonathan LeBlanc
" License: Creative Commons (http://creativecommons.org/licenses/by-sa/2.0/)
" Useage:
"    url = 'http://www.nhl.com/ice/player.htm?id=8468482';
"    og_instance = OpenGraphParser(url)  
"    print og_instance.get_one('og:title')
"    print og_instance.get_all()
"""
class OpenGraphParser:
    og_content = {}
    
    """
    " Method: Init
    " Description: Inicjalizuje obiekt pobierający znaczniki OG. Jeśli adres
    "              URL został zaakceptowany, pole og_content będzie zawierało
    "              wartość zwróconą przez metodę get_graph.
    " Arguments: url (string) - Adres URL strony zawierającej znaczniki OG
    """
    def __init__(self, url):
        if url is not None:
            self.og_content = self.get_graph(url)
    
    """
    " Method: Get Open Graph
    " Description: Pobiera kod jezyka HTML z przekazanego adresu URL, po czym
    "              filtruje i pozostawia tylko znaczniki meta. Przetwarza
    "              wszystkie znaczniki meta rozpoczynające się od przedrostka
    "              og: i zwraca je do metody init.
    " Arguments: url (string) - Adres URL strony zawierającej znaczniki OG
    " Returns: dictionary - Dopasowane znaczniki OG
    """
    def get_graph(self, url):
        # Uzyskuje wszystkie znaczniki meta z przekazanego adresu URL
        sock = urllib.urlopen(url) 
        htmlSource = sock.read()                            
        sock.close()                                        
        soup = BeautifulSoup(htmlSource)
        meta = soup.findAll('meta')
        
        # Uzyskuje wszystkie znaczniki og:* z metadanych
        content = {}
        for tag in meta:
            if tag.has_key('property'):
                if re.search('og:', tag['property']) is not None:
                    content[re.sub('og:', '', tag['property'])] = tag['content']
                    
        return content
    
    """
    " Method: Get One Tag
    " Description: Uzyskuje treść jednego znacznika OG
    " Arguments: tag (string) - Znacznik OG, którego treść zostanie zwrócona
    " Returns: string - Wartość znacznika OG
    """
    def get_one(self, tag):
        return self.og_content[tag]
    
    """
    " Method: Get All Tags
    " Description: Zwraca wszystkie znalezione znaczniki OG
    " Returns: dictionary - Wszystkie znaczniki OG
    """  
    def get_all(self):
        return self.og_content
