<?php
/*******************************************************************************
 * Class Name: Parser Open Graph 
 * Description: Wykonuje analizę składniową dokumentu HTML, aby uzyskać i
 *              zapisać znaczniki Open Graph zawarte w metadanych
 * Author: Jonathan LeBlanc (Twitter: @jcleblanc)
 * License: Creative Commons (http://creativecommons.org/licenses/by-sa/2.0/)
 * Useage: 
 *   $url = 'http://www.example.com/index.html';
 *   $graph = new OpenGraph($url);
 *   print_r($graph->get_one('title'));  // uzyskuje tylko element title
 *   print_r($graph->get_all());         // zwraca wszystkie znaczniki Open Graph
 ******************************************************************************/
class OpenGraph{
    //the open graph associative array
    private static $og_content = array();
    
    /***************************************************************************
     * Function: Konstruktor klasy
     * Description: Konstruuje żądanie pobrania danych OG
     * Params: $url (string) - Adres URL strony zawierającej znaczniki OG
     **************************************************************************/
    public function __construct($url){
        if ($url){
            self::$og_content = self::get_graph($url);    
        }
    }
    
    /***************************************************************************
     * Function: Get Open Graph
     * Description: Konstruuje żądanie pobrania danych OG
     * Params: $url (string) - Adres URL strony zawierającej znaczniki OG
     * Return: Object - tablica asocjacyjna zawierająca dane OG w formacie
     *                  właściwość : treść
     **************************************************************************/
    private function get_graph($url){
        // Uzyskuje treść HTML ze źródła w internecie i wyodrębnia metadane
        $dom = new DOMDocument();
        @$dom->loadHtmlFile($url);
        $tags = $dom->getElementsByTagName('meta');
        
        // Ustawia wzorzec pasujący do znaczników OG i zwracany obiekt
        $og_pattern = '/^og:/';
        $graph_content = array();
        
        // Dla każdego otwartego znacznika OG zapisuje w zwracanym obiekcie parę
        // właściwość : treść
        foreach ($tags as $element){
            if (preg_match($og_pattern, $element->getAttribute('property'))){
                $graph_content[preg_replace($og_pattern, '', $element->getAttribute('property'))] = $element->getAttribute('content');
            }
        }
        
        // Zwraca wszystkie znalezione znaczniki Open Graph
        return $graph_content;
    }
    
    /***************************************************************************
     * Function: Get One Tag
     * Description: Uzyskuje treść jednego znacznika OG
     * Return: String - Treść żądanego znacznika OG
     **************************************************************************/
    public function get_one($element){
        return self::$og_content[$element];
    }
    
    /***************************************************************************
     * Function: Get All Tags
     * Description: Uzyskuje treść wszystkich znaczników OG
     * Return: Object - Cała tablica asocjacyjna ze znacznikami OG
     **************************************************************************/
    public function get_all(){
        return self::$og_content;
    }
}
?>
