/*
 * Decompiled with CFR 0.152.
 */
package androidx.savedstate;

import android.annotation.SuppressLint;
import android.os.Bundle;
import androidx.annotation.NonNull;
import androidx.lifecycle.GenericLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.savedstate.SavedStateRegistry;
import androidx.savedstate.SavedStateRegistryOwner;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

@SuppressLint(value={"RestrictedApi"})
final class Recreator
implements GenericLifecycleObserver {
    static final String CLASSES_KEY = "classes_to_restore";
    static final String COMPONENT_KEY = "androidx.savedstate.Restarter";
    private final SavedStateRegistryOwner mOwner;

    Recreator(SavedStateRegistryOwner owner) {
        this.mOwner = owner;
    }

    public void onStateChanged(LifecycleOwner source, Lifecycle.Event event) {
        if (event != Lifecycle.Event.ON_CREATE) {
            throw new AssertionError((Object)"Next event must be ON_CREATE");
        }
        source.getLifecycle().removeObserver((LifecycleObserver)this);
        Bundle bundle = this.mOwner.getSavedStateRegistry().consumeRestoredStateForKey(COMPONENT_KEY);
        if (bundle == null) {
            return;
        }
        ArrayList classes = bundle.getStringArrayList(CLASSES_KEY);
        if (classes == null) {
            throw new IllegalStateException("Bundle with restored state for the component \"androidx.savedstate.Restarter\" must contain list of strings by the key \"classes_to_restore\"");
        }
        for (String className : classes) {
            this.reflectiveNew(className);
        }
    }

    private void reflectiveNew(String className) {
        SavedStateRegistry.AutoRecreated newInstance;
        Constructor<SavedStateRegistry.AutoRecreated> constructor;
        Class<SavedStateRegistry.AutoRecreated> clazz;
        try {
            clazz = Class.forName(className, false, Recreator.class.getClassLoader()).asSubclass(SavedStateRegistry.AutoRecreated.class);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Class " + className + " wasn't found", e);
        }
        try {
            constructor = clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalStateException("Class" + clazz.getSimpleName() + " must have default constructor in order to be automatically recreated", e);
        }
        constructor.setAccessible(true);
        try {
            newInstance = constructor.newInstance(new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to instantiate " + className, e);
        }
        newInstance.onRecreated(this.mOwner);
    }

    static final class SavedStateProvider
    implements SavedStateRegistry.SavedStateProvider {
        final Set<String> mClasses = new HashSet<String>();

        SavedStateProvider(SavedStateRegistry registry) {
            registry.registerSavedStateProvider(Recreator.COMPONENT_KEY, this);
        }

        @Override
        @NonNull
        public Bundle saveState() {
            Bundle bundle = new Bundle();
            bundle.putStringArrayList(Recreator.CLASSES_KEY, new ArrayList<String>(this.mClasses));
            return bundle;
        }

        void add(String className) {
            this.mClasses.add(className);
        }
    }
}

