/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import java.util.Arrays;

final class ColorUtils {
    private static final float[] WHITE_POINT_D65 = new float[]{95.047f, 100.0f, 108.883f};

    private ColorUtils() {
    }

    public static final float[] whitePointD65() {
        return Arrays.copyOf(WHITE_POINT_D65, 3);
    }

    public static int redFromInt(int argb) {
        return (argb & 0xFF0000) >> 16;
    }

    public static int greenFromInt(int argb) {
        return (argb & 0xFF00) >> 8;
    }

    public static int blueFromInt(int argb) {
        return argb & 0xFF;
    }

    public static float lstarFromInt(int argb) {
        return (float)ColorUtils.labFromInt(argb)[0];
    }

    public static String hexFromInt(int argb) {
        int red = ColorUtils.redFromInt(argb);
        int blue = ColorUtils.blueFromInt(argb);
        int green = ColorUtils.greenFromInt(argb);
        return String.format("#%02x%02x%02x", red, green, blue);
    }

    public static float[] xyzFromInt(int argb) {
        float r = ColorUtils.linearized((float)ColorUtils.redFromInt(argb) / 255.0f) * 100.0f;
        float g = ColorUtils.linearized((float)ColorUtils.greenFromInt(argb) / 255.0f) * 100.0f;
        float b = ColorUtils.linearized((float)ColorUtils.blueFromInt(argb) / 255.0f) * 100.0f;
        float x = 0.41233894f * r + 0.35762063f * g + 0.18051042f * b;
        float y = 0.2126f * r + 0.7152f * g + 0.0722f * b;
        float z = 0.01932141f * r + 0.11916382f * g + 0.9503448f * b;
        return new float[]{x, y, z};
    }

    public static int intFromRgb(int r, int g, int b) {
        return (0xFF000000 | (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF) >>> 0;
    }

    public static double[] labFromInt(int argb) {
        double e = 0.008856451679035631;
        double kappa = 903.2962962962963;
        float[] xyz = ColorUtils.xyzFromInt(argb);
        double yNormalized = xyz[1] / WHITE_POINT_D65[1];
        double fy = yNormalized > 0.008856451679035631 ? Math.cbrt(yNormalized) : (903.2962962962963 * yNormalized + 16.0) / 116.0;
        double xNormalized = xyz[0] / WHITE_POINT_D65[0];
        double fx = xNormalized > 0.008856451679035631 ? Math.cbrt(xNormalized) : (903.2962962962963 * xNormalized + 16.0) / 116.0;
        double zNormalized = xyz[2] / WHITE_POINT_D65[2];
        double fz = zNormalized > 0.008856451679035631 ? Math.cbrt(zNormalized) : (903.2962962962963 * zNormalized + 16.0) / 116.0;
        double l = 116.0 * fy - 16.0;
        double a = 500.0 * (fx - fy);
        double b = 200.0 * (fy - fz);
        return new double[]{l, a, b};
    }

    public static int intFromLab(double l, double a, double b) {
        double e = 0.008856451679035631;
        double kappa = 903.2962962962963;
        double ke = 8.0;
        double fy = (l + 16.0) / 116.0;
        double fx = a / 500.0 + fy;
        double fz = fy - b / 200.0;
        double fx3 = fx * fx * fx;
        double xNormalized = fx3 > 0.008856451679035631 ? fx3 : (116.0 * fx - 16.0) / 903.2962962962963;
        double yNormalized = l > 8.0 ? fy * fy * fy : l / 903.2962962962963;
        double fz3 = fz * fz * fz;
        double zNormalized = fz3 > 0.008856451679035631 ? fz3 : (116.0 * fz - 16.0) / 903.2962962962963;
        double x = xNormalized * (double)WHITE_POINT_D65[0];
        double y = yNormalized * (double)WHITE_POINT_D65[1];
        double z = zNormalized * (double)WHITE_POINT_D65[2];
        return ColorUtils.intFromXyzComponents((float)x, (float)y, (float)z);
    }

    public static int intFromXyzComponents(float x, float y, float z) {
        float rL = (x /= 100.0f) * 3.2406f + (y /= 100.0f) * -1.5372f + (z /= 100.0f) * -0.4986f;
        float gL = x * -0.9689f + y * 1.8758f + z * 0.0415f;
        float bL = x * 0.0557f + y * -0.204f + z * 1.057f;
        float r = ColorUtils.delinearized(rL);
        float g = ColorUtils.delinearized(gL);
        float b = ColorUtils.delinearized(bL);
        int rInt = Math.max(Math.min(255, Math.round(r * 255.0f)), 0);
        int gInt = Math.max(Math.min(255, Math.round(g * 255.0f)), 0);
        int bInt = Math.max(Math.min(255, Math.round(b * 255.0f)), 0);
        return ColorUtils.intFromRgb(rInt, gInt, bInt);
    }

    public static int intFromXyz(float[] xyz) {
        return ColorUtils.intFromXyzComponents(xyz[0], xyz[1], xyz[2]);
    }

    public static int intFromLstar(float lstar) {
        float fy;
        float fz = fy = (lstar + 16.0f) / 116.0f;
        float fx = fy;
        float kappa = 903.2963f;
        float epsilon = 0.008856452f;
        boolean cubeExceedEpsilon = fy * fy * fy > epsilon;
        boolean lExceedsEpsilonKappa = lstar > 8.0f;
        float y = lExceedsEpsilonKappa ? fy * fy * fy : lstar / kappa;
        float x = cubeExceedEpsilon ? fx * fx * fx : (116.0f * fx - 16.0f) / kappa;
        float z = cubeExceedEpsilon ? fz * fz * fz : (116.0f * fx - 16.0f) / kappa;
        float[] xyz = new float[]{x * WHITE_POINT_D65[0], y * WHITE_POINT_D65[1], z * WHITE_POINT_D65[2]};
        return ColorUtils.intFromXyz(xyz);
    }

    public static float yFromLstar(float lstar) {
        float ke = 8.0f;
        if (lstar > ke) {
            return (float)Math.pow(((double)lstar + 16.0) / 116.0, 3.0) * 100.0f;
        }
        return lstar / 903.2963f * 100.0f;
    }

    public static float linearized(float rgb) {
        if (rgb <= 0.04045f) {
            return rgb / 12.92f;
        }
        return (float)Math.pow((rgb + 0.055f) / 1.055f, 2.4f);
    }

    public static float delinearized(float rgb) {
        if (rgb <= 0.0031308f) {
            return rgb * 12.92f;
        }
        return 1.055f * (float)Math.pow(rgb, 0.4166666567325592) - 0.055f;
    }
}

