/*
 * Decompiled with CFR 0.152.
 */
package androidx.loader.content;

import android.content.Context;
import android.os.AsyncTask;
import android.os.Handler;
import android.os.SystemClock;
import android.text.format.DateUtils;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.core.os.OperationCanceledException;
import androidx.loader.content.Loader;
import androidx.loader.content.ModernAsyncTask;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public abstract class AsyncTaskLoader<D>
extends Loader<D> {
    private static final String TAG = "AsyncTaskLoader";
    private static final boolean DEBUG = false;
    private Executor mExecutor;
    private volatile LoadTask mTask;
    private volatile LoadTask mCancellingTask;
    private long mUpdateThrottle;
    private long mLastLoadCompleteTime = -10000L;
    private Handler mHandler;

    public AsyncTaskLoader(@NonNull Context context) {
        super(context);
    }

    public void setUpdateThrottle(long delayMS) {
        this.mUpdateThrottle = delayMS;
        if (delayMS != 0L) {
            this.mHandler = new Handler();
        }
    }

    @Override
    protected void onForceLoad() {
        super.onForceLoad();
        this.cancelLoad();
        this.mTask = new LoadTask();
        this.executePendingTask();
    }

    @Override
    protected boolean onCancelLoad() {
        if (this.mTask != null) {
            if (!this.isStarted()) {
                this.onContentChanged();
            }
            if (this.mCancellingTask != null) {
                if (this.mTask.waiting) {
                    this.mTask.waiting = false;
                    this.mHandler.removeCallbacks((Runnable)this.mTask);
                }
                this.mTask = null;
                return false;
            }
            if (this.mTask.waiting) {
                this.mTask.waiting = false;
                this.mHandler.removeCallbacks((Runnable)this.mTask);
                this.mTask = null;
                return false;
            }
            boolean cancelled = this.mTask.cancel(false);
            if (cancelled) {
                this.mCancellingTask = this.mTask;
                this.cancelLoadInBackground();
            }
            this.mTask = null;
            return cancelled;
        }
        return false;
    }

    public void onCanceled(@Nullable D data) {
    }

    void executePendingTask() {
        if (this.mCancellingTask == null && this.mTask != null) {
            long now;
            if (this.mTask.waiting) {
                this.mTask.waiting = false;
                this.mHandler.removeCallbacks((Runnable)this.mTask);
            }
            if (this.mUpdateThrottle > 0L && (now = SystemClock.uptimeMillis()) < this.mLastLoadCompleteTime + this.mUpdateThrottle) {
                this.mTask.waiting = true;
                this.mHandler.postAtTime((Runnable)this.mTask, this.mLastLoadCompleteTime + this.mUpdateThrottle);
                return;
            }
            if (this.mExecutor == null) {
                this.mExecutor = this.getExecutor();
            }
            this.mTask.executeOnExecutor(this.mExecutor);
        }
    }

    void dispatchOnCancelled(LoadTask task, D data) {
        this.onCanceled(data);
        if (this.mCancellingTask == task) {
            this.rollbackContentChanged();
            this.mLastLoadCompleteTime = SystemClock.uptimeMillis();
            this.mCancellingTask = null;
            this.deliverCancellation();
            this.executePendingTask();
        }
    }

    void dispatchOnLoadComplete(LoadTask task, D data) {
        if (this.mTask != task) {
            this.dispatchOnCancelled(task, data);
        } else if (this.isAbandoned()) {
            this.onCanceled(data);
        } else {
            this.commitContentChanged();
            this.mLastLoadCompleteTime = SystemClock.uptimeMillis();
            this.mTask = null;
            this.deliverResult(data);
        }
    }

    @Nullable
    public abstract D loadInBackground();

    @Nullable
    protected D onLoadInBackground() {
        return this.loadInBackground();
    }

    public void cancelLoadInBackground() {
    }

    public boolean isLoadInBackgroundCanceled() {
        return this.mCancellingTask != null;
    }

    @NonNull
    protected Executor getExecutor() {
        return AsyncTask.THREAD_POOL_EXECUTOR;
    }

    @Override
    @Deprecated
    public void dump(String prefix, FileDescriptor fd, PrintWriter writer, String[] args) {
        super.dump(prefix, fd, writer, args);
        if (this.mTask != null) {
            writer.print(prefix);
            writer.print("mTask=");
            writer.print(this.mTask);
            writer.print(" waiting=");
            writer.println(this.mTask.waiting);
        }
        if (this.mCancellingTask != null) {
            writer.print(prefix);
            writer.print("mCancellingTask=");
            writer.print(this.mCancellingTask);
            writer.print(" waiting=");
            writer.println(this.mCancellingTask.waiting);
        }
        if (this.mUpdateThrottle != 0L) {
            writer.print(prefix);
            writer.print("mUpdateThrottle=");
            writer.print(DateUtils.formatElapsedTime((long)TimeUnit.MILLISECONDS.toSeconds(this.mUpdateThrottle)));
            writer.print(" mLastLoadCompleteTime=");
            writer.print(this.mLastLoadCompleteTime == -10000L ? "--" : "-" + DateUtils.formatElapsedTime((long)TimeUnit.MILLISECONDS.toSeconds(SystemClock.uptimeMillis() - this.mLastLoadCompleteTime)));
            writer.println();
        }
    }

    final class LoadTask
    extends ModernAsyncTask<D>
    implements Runnable {
        boolean waiting;

        LoadTask() {
        }

        @Override
        protected D doInBackground() {
            try {
                Object data = AsyncTaskLoader.this.onLoadInBackground();
                return data;
            }
            catch (OperationCanceledException ex) {
                if (!this.isCancelled()) {
                    throw ex;
                }
                return null;
            }
        }

        @Override
        protected void onPostExecute(D data) {
            AsyncTaskLoader.this.dispatchOnLoadComplete(this, data);
        }

        @Override
        protected void onCancelled(D data) {
            AsyncTaskLoader.this.dispatchOnCancelled(this, data);
        }

        @Override
        public void run() {
            this.waiting = false;
            AsyncTaskLoader.this.executePendingTask();
        }
    }
}

