/*
 * Decompiled with CFR 0.152.
 */
package com.bumptech.glide.load.engine.cache;

import android.content.Context;
import androidx.annotation.Nullable;
import com.bumptech.glide.load.engine.cache.DiskLruCacheFactory;
import java.io.File;

public final class ExternalPreferredCacheDiskCacheFactory
extends DiskLruCacheFactory {
    public ExternalPreferredCacheDiskCacheFactory(Context context) {
        this(context, "image_manager_disk_cache", 0xFA00000L);
    }

    public ExternalPreferredCacheDiskCacheFactory(Context context, long diskCacheSize) {
        this(context, "image_manager_disk_cache", diskCacheSize);
    }

    public ExternalPreferredCacheDiskCacheFactory(final Context context, final String diskCacheName, long diskCacheSize) {
        super(new DiskLruCacheFactory.CacheDirectoryGetter(){

            @Nullable
            private File getInternalCacheDirectory() {
                File cacheDirectory = context.getCacheDir();
                if (cacheDirectory == null) {
                    return null;
                }
                if (diskCacheName != null) {
                    return new File(cacheDirectory, diskCacheName);
                }
                return cacheDirectory;
            }

            @Override
            public File getCacheDirectory() {
                File internalCacheDirectory = this.getInternalCacheDirectory();
                if (null != internalCacheDirectory && internalCacheDirectory.exists()) {
                    return internalCacheDirectory;
                }
                File cacheDirectory = context.getExternalCacheDir();
                if (cacheDirectory == null || !cacheDirectory.canWrite()) {
                    return internalCacheDirectory;
                }
                if (diskCacheName != null) {
                    return new File(cacheDirectory, diskCacheName);
                }
                return cacheDirectory;
            }
        }, diskCacheSize);
    }
}

