/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.shape;

import androidx.annotation.NonNull;
import com.google.android.material.shape.EdgeTreatment;
import com.google.android.material.shape.ShapePath;

public final class MarkerEdgeTreatment
extends EdgeTreatment {
    private final float radius;

    public MarkerEdgeTreatment(float radius) {
        this.radius = radius - 0.001f;
    }

    @Override
    public void getEdgePath(float length, float center, float interpolation, @NonNull ShapePath shapePath) {
        float side = (float)((double)this.radius * Math.sqrt(2.0) / 2.0);
        float side2 = (float)Math.sqrt(Math.pow(this.radius, 2.0) - Math.pow(side, 2.0));
        shapePath.reset(center - side, (float)(-((double)this.radius * Math.sqrt(2.0) - (double)this.radius)) + side2);
        shapePath.lineTo(center, (float)(-((double)this.radius * Math.sqrt(2.0) - (double)this.radius)));
        shapePath.lineTo(center + side, (float)(-((double)this.radius * Math.sqrt(2.0) - (double)this.radius)) + side2);
    }

    @Override
    boolean forceIntersection() {
        return true;
    }
}

