/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.color;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.TypedArray;
import android.content.res.loader.ResourcesLoader;
import android.os.Build;
import android.view.ContextThemeWrapper;
import androidx.annotation.ChecksSdkIntAtLeast;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RequiresApi;
import androidx.core.content.ContextCompat;
import com.google.android.material.R;
import com.google.android.material.color.ColorResourcesLoaderCreator;
import com.google.android.material.color.HarmonizedColorAttributes;
import com.google.android.material.color.HarmonizedColorsOptions;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.color.ThemeUtils;
import java.util.HashMap;
import java.util.Map;

public class HarmonizedColors {
    private static final String TAG = HarmonizedColors.class.getSimpleName();

    private HarmonizedColors() {
    }

    @NonNull
    public static void applyToContextIfAvailable(@NonNull Context context, @NonNull HarmonizedColorsOptions options) {
        if (!HarmonizedColors.isHarmonizedColorAvailable()) {
            return;
        }
        Map<Integer, Integer> colorReplacementMap = HarmonizedColors.createHarmonizedColorReplacementMap(context, options);
        int themeOverlay = options.getThemeOverlayResourceId(0);
        if (HarmonizedColors.addResourcesLoaderToContext(context, colorReplacementMap) && themeOverlay != 0) {
            ThemeUtils.applyThemeOverlay(context, themeOverlay);
        }
    }

    @NonNull
    public static Context wrapContextIfAvailable(@NonNull Context context, @NonNull HarmonizedColorsOptions options) {
        if (!HarmonizedColors.isHarmonizedColorAvailable()) {
            return context;
        }
        Map<Integer, Integer> colorReplacementMap = HarmonizedColors.createHarmonizedColorReplacementMap(context, options);
        int themeOverlay = options.getThemeOverlayResourceId(R.style.ThemeOverlay_Material3_HarmonizedColors_Empty);
        ContextThemeWrapper themeWrapper = new ContextThemeWrapper(context, themeOverlay);
        themeWrapper.applyOverrideConfiguration(new Configuration());
        return HarmonizedColors.addResourcesLoaderToContext((Context)themeWrapper, colorReplacementMap) ? themeWrapper : context;
    }

    @ChecksSdkIntAtLeast(api=30)
    public static boolean isHarmonizedColorAvailable() {
        return Build.VERSION.SDK_INT >= 30;
    }

    @RequiresApi(api=21)
    private static Map<Integer, Integer> createHarmonizedColorReplacementMap(Context originalContext, HarmonizedColorsOptions options) {
        int[] attributes;
        HashMap<Integer, Integer> colorReplacementMap = new HashMap<Integer, Integer>();
        int colorToHarmonizeWith = MaterialColors.getColor(originalContext, options.getColorAttributeToHarmonizeWith(), TAG);
        for (int colorResourceId : options.getColorResourceIds()) {
            int harmonizedColor = MaterialColors.harmonize(ContextCompat.getColor((Context)originalContext, (int)colorResourceId), colorToHarmonizeWith);
            colorReplacementMap.put(colorResourceId, harmonizedColor);
        }
        HarmonizedColorAttributes colorAttributes = options.getColorAttributes();
        if (colorAttributes != null && (attributes = colorAttributes.getAttributes()).length > 0) {
            int themeOverlay = colorAttributes.getThemeOverlay();
            TypedArray themeAttributesTypedArray = originalContext.obtainStyledAttributes(attributes);
            TypedArray themeOverlayAttributesTypedArray = themeOverlay != 0 ? new ContextThemeWrapper(originalContext, themeOverlay).obtainStyledAttributes(attributes) : null;
            HarmonizedColors.addHarmonizedColorAttributesToReplacementMap(colorReplacementMap, themeAttributesTypedArray, themeOverlayAttributesTypedArray, colorToHarmonizeWith);
            themeAttributesTypedArray.recycle();
            if (themeOverlayAttributesTypedArray != null) {
                themeOverlayAttributesTypedArray.recycle();
            }
        }
        return colorReplacementMap;
    }

    @RequiresApi(api=30)
    private static boolean addResourcesLoaderToContext(Context context, Map<Integer, Integer> colorReplacementMap) {
        ResourcesLoader resourcesLoader = ColorResourcesLoaderCreator.create(context, colorReplacementMap);
        if (resourcesLoader != null) {
            context.getResources().addLoaders(new ResourcesLoader[]{resourcesLoader});
            return true;
        }
        return false;
    }

    @RequiresApi(api=21)
    private static void addHarmonizedColorAttributesToReplacementMap(@NonNull Map<Integer, Integer> colorReplacementMap, @NonNull TypedArray themeAttributesTypedArray, @Nullable TypedArray themeOverlayAttributesTypedArray, @ColorInt int colorToHarmonizeWith) {
        TypedArray resourceIdTypedArray = themeOverlayAttributesTypedArray != null ? themeOverlayAttributesTypedArray : themeAttributesTypedArray;
        for (int i = 0; i < themeAttributesTypedArray.getIndexCount(); ++i) {
            int resourceId = resourceIdTypedArray.getResourceId(i, 0);
            if (resourceId == 0 || !themeAttributesTypedArray.hasValue(i) || !HarmonizedColors.isColorResource(themeAttributesTypedArray.getType(i))) continue;
            int colorToHarmonize = themeAttributesTypedArray.getColor(i, 0);
            colorReplacementMap.put(resourceId, MaterialColors.harmonize(colorToHarmonize, colorToHarmonizeWith));
        }
    }

    private static boolean isColorResource(int attrType) {
        return 28 <= attrType && attrType <= 31;
    }
}

