/*
 * Decompiled with CFR 0.152.
 */
package androidx.savedstate;

import android.annotation.SuppressLint;
import android.os.Bundle;
import androidx.annotation.MainThread;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.arch.core.internal.SafeIterableMap;
import androidx.lifecycle.GenericLifecycleObserver;
import androidx.lifecycle.Lifecycle;
import androidx.lifecycle.LifecycleObserver;
import androidx.lifecycle.LifecycleOwner;
import androidx.savedstate.Recreator;
import androidx.savedstate.SavedStateRegistryOwner;
import java.util.Map;

@SuppressLint(value={"RestrictedApi"})
public final class SavedStateRegistry {
    private static final String SAVED_COMPONENTS_KEY = "androidx.lifecycle.BundlableSavedStateRegistry.key";
    private SafeIterableMap<String, SavedStateProvider> mComponents = new SafeIterableMap();
    @Nullable
    private Bundle mRestoredState;
    private boolean mRestored;
    private Recreator.SavedStateProvider mRecreatorProvider;
    boolean mAllowingSavingState = true;

    SavedStateRegistry() {
    }

    @MainThread
    @Nullable
    public Bundle consumeRestoredStateForKey(@NonNull String key) {
        if (!this.mRestored) {
            throw new IllegalStateException("You can consumeRestoredStateForKey only after super.onCreate of corresponding component");
        }
        if (this.mRestoredState != null) {
            Bundle result = this.mRestoredState.getBundle(key);
            this.mRestoredState.remove(key);
            if (this.mRestoredState.isEmpty()) {
                this.mRestoredState = null;
            }
            return result;
        }
        return null;
    }

    @MainThread
    public void registerSavedStateProvider(@NonNull String key, @NonNull SavedStateProvider provider) {
        SavedStateProvider previous = (SavedStateProvider)this.mComponents.putIfAbsent((Object)key, (Object)provider);
        if (previous != null) {
            throw new IllegalArgumentException("SavedStateProvider with the given key is already registered");
        }
    }

    @MainThread
    public void unregisterSavedStateProvider(@NonNull String key) {
        this.mComponents.remove((Object)key);
    }

    @MainThread
    public boolean isRestored() {
        return this.mRestored;
    }

    @MainThread
    public void runOnNextRecreation(@NonNull Class<? extends AutoRecreated> clazz) {
        if (!this.mAllowingSavingState) {
            throw new IllegalStateException("Can not perform this action after onSaveInstanceState");
        }
        if (this.mRecreatorProvider == null) {
            this.mRecreatorProvider = new Recreator.SavedStateProvider(this);
        }
        try {
            clazz.getDeclaredConstructor(new Class[0]);
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("Class" + clazz.getSimpleName() + " must have default constructor in order to be automatically recreated", e);
        }
        this.mRecreatorProvider.add(clazz.getName());
    }

    @MainThread
    void performRestore(@NonNull Lifecycle lifecycle, @Nullable Bundle savedState) {
        if (this.mRestored) {
            throw new IllegalStateException("SavedStateRegistry was already restored.");
        }
        if (savedState != null) {
            this.mRestoredState = savedState.getBundle(SAVED_COMPONENTS_KEY);
        }
        lifecycle.addObserver((LifecycleObserver)new GenericLifecycleObserver(){

            public void onStateChanged(LifecycleOwner source, Lifecycle.Event event) {
                if (event == Lifecycle.Event.ON_START) {
                    SavedStateRegistry.this.mAllowingSavingState = true;
                } else if (event == Lifecycle.Event.ON_STOP) {
                    SavedStateRegistry.this.mAllowingSavingState = false;
                }
            }
        });
        this.mRestored = true;
    }

    @MainThread
    void performSave(@NonNull Bundle outBundle) {
        Bundle components = new Bundle();
        if (this.mRestoredState != null) {
            components.putAll(this.mRestoredState);
        }
        SafeIterableMap.IteratorWithAdditions it = this.mComponents.iteratorWithAdditions();
        while (it.hasNext()) {
            Map.Entry entry1 = (Map.Entry)it.next();
            components.putBundle((String)entry1.getKey(), ((SavedStateProvider)entry1.getValue()).saveState());
        }
        outBundle.putBundle(SAVED_COMPONENTS_KEY, components);
    }

    public static interface SavedStateProvider {
        @NonNull
        public Bundle saveState();
    }

    public static interface AutoRecreated {
        public void onRecreated(@NonNull SavedStateRegistryOwner var1);
    }
}

