/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Point;
import android.graphics.Rect;
import android.os.Build;
import android.util.Log;
import android.view.Display;
import android.view.DisplayCutout;
import android.view.WindowManager;
import androidx.annotation.RequiresApi;
import androidx.annotation.VisibleForTesting;
import androidx.window.layout.ActivityCompatHelperApi24;
import androidx.window.layout.ActivityCompatHelperApi30;
import androidx.window.layout.DisplayCompatHelperApi17;
import androidx.window.layout.DisplayCompatHelperApi28;
import androidx.window.layout.WindowMetrics;
import androidx.window.layout.WindowMetricsCalculator;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u00c0\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0010\u0010\t\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0015\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\fJ\u0015\u0010\r\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\u000eJ\u0015\u0010\u000f\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\u0010J\u0015\u0010\u0011\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0001\u00a2\u0006\u0002\b\u0012J\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0003J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J\u0015\u0010\u001b\u001a\u00020\u001c2\u0006\u0010\u0015\u001a\u00020\u0016H\u0001\u00a2\u0006\u0002\b\u001dJ\u0018\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010 \u001a\u00020\u000bH\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006!"}, d2={"Landroidx/window/layout/WindowMetricsCalculatorCompat;", "Landroidx/window/layout/WindowMetricsCalculator;", "()V", "TAG", "", "computeCurrentWindowMetrics", "Landroidx/window/layout/WindowMetrics;", "activity", "Landroid/app/Activity;", "computeMaximumWindowMetrics", "computeWindowBoundsIceCreamSandwich", "Landroid/graphics/Rect;", "computeWindowBoundsIceCreamSandwich$window_release", "computeWindowBoundsN", "computeWindowBoundsN$window_release", "computeWindowBoundsP", "computeWindowBoundsP$window_release", "computeWindowBoundsQ", "computeWindowBoundsQ$window_release", "getCutoutForDisplay", "Landroid/view/DisplayCutout;", "display", "Landroid/view/Display;", "getNavigationBarHeight", "", "context", "Landroid/content/Context;", "getRealSizeForDisplay", "Landroid/graphics/Point;", "getRealSizeForDisplay$window_release", "getRectSizeFromDisplay", "", "bounds", "window_release"})
public final class WindowMetricsCalculatorCompat
implements WindowMetricsCalculator {
    @NotNull
    public static final WindowMetricsCalculatorCompat INSTANCE = new WindowMetricsCalculatorCompat();
    @NotNull
    private static final String TAG;

    private WindowMetricsCalculatorCompat() {
    }

    @Override
    @NotNull
    public WindowMetrics computeCurrentWindowMetrics(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Rect bounds = Build.VERSION.SDK_INT >= 30 ? ActivityCompatHelperApi30.INSTANCE.currentWindowBounds(activity) : (Build.VERSION.SDK_INT >= 29 ? this.computeWindowBoundsQ$window_release(activity) : (Build.VERSION.SDK_INT >= 28 ? this.computeWindowBoundsP$window_release(activity) : (Build.VERSION.SDK_INT >= 24 ? this.computeWindowBoundsN$window_release(activity) : this.computeWindowBoundsIceCreamSandwich$window_release(activity))));
        return new WindowMetrics(bounds);
    }

    @Override
    @NotNull
    public WindowMetrics computeMaximumWindowMetrics(@NotNull Activity activity) {
        Rect rect;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        if (Build.VERSION.SDK_INT >= 30) {
            rect = ActivityCompatHelperApi30.INSTANCE.maximumWindowBounds(activity);
        } else {
            Display display = activity.getWindowManager().getDefaultDisplay();
            Intrinsics.checkNotNullExpressionValue((Object)display, (String)"display");
            Point displaySize = this.getRealSizeForDisplay$window_release(display);
            rect = new Rect(0, 0, displaySize.x, displaySize.y);
        }
        Rect bounds = rect;
        return new WindowMetrics(bounds);
    }

    @SuppressLint(value={"BanUncheckedReflection", "BlockedPrivateApi"})
    @RequiresApi(value=29)
    @NotNull
    public final Rect computeWindowBoundsQ$window_release(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Rect bounds = null;
        Configuration config = activity.getResources().getConfiguration();
        try {
            Field windowConfigField = Configuration.class.getDeclaredField("windowConfiguration");
            windowConfigField.setAccessible(true);
            Object windowConfig = windowConfigField.get(config);
            Method getBoundsMethod = windowConfig.getClass().getDeclaredMethod("getBounds", new Class[0]);
            Object object = getBoundsMethod.invoke(windowConfig, new Object[0]);
            if (object == null) {
                throw new NullPointerException("null cannot be cast to non-null type android.graphics.Rect");
            }
            bounds = new Rect((Rect)object);
        }
        catch (NoSuchFieldException e) {
            Log.w((String)TAG, (Throwable)e);
            bounds = this.computeWindowBoundsP$window_release(activity);
        }
        catch (NoSuchMethodException e) {
            Log.w((String)TAG, (Throwable)e);
            bounds = this.computeWindowBoundsP$window_release(activity);
        }
        catch (IllegalAccessException e) {
            Log.w((String)TAG, (Throwable)e);
            bounds = this.computeWindowBoundsP$window_release(activity);
        }
        catch (InvocationTargetException e) {
            Log.w((String)TAG, (Throwable)e);
            bounds = this.computeWindowBoundsP$window_release(activity);
        }
        return bounds;
    }

    @SuppressLint(value={"BanUncheckedReflection", "BlockedPrivateApi"})
    @RequiresApi(value=28)
    @NotNull
    public final Rect computeWindowBoundsP$window_release(@NotNull Activity activity) {
        DisplayCutout displayCutout;
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Rect bounds = new Rect();
        Configuration config = activity.getResources().getConfiguration();
        try {
            Method getAppBounds;
            Field windowConfigField = Configuration.class.getDeclaredField("windowConfiguration");
            windowConfigField.setAccessible(true);
            Object windowConfig = windowConfigField.get(config);
            if (ActivityCompatHelperApi24.INSTANCE.isInMultiWindowMode(activity)) {
                getAppBounds = windowConfig.getClass().getDeclaredMethod("getBounds", new Class[0]);
                Object object = getAppBounds.invoke(windowConfig, new Object[0]);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.graphics.Rect");
                }
                bounds.set((Rect)object);
            } else {
                getAppBounds = windowConfig.getClass().getDeclaredMethod("getAppBounds", new Class[0]);
                Object object = getAppBounds.invoke(windowConfig, new Object[0]);
                if (object == null) {
                    throw new NullPointerException("null cannot be cast to non-null type android.graphics.Rect");
                }
                bounds.set((Rect)object);
            }
        }
        catch (NoSuchFieldException e) {
            Log.w((String)TAG, (Throwable)e);
            this.getRectSizeFromDisplay(activity, bounds);
        }
        catch (NoSuchMethodException e) {
            Log.w((String)TAG, (Throwable)e);
            this.getRectSizeFromDisplay(activity, bounds);
        }
        catch (IllegalAccessException e) {
            Log.w((String)TAG, (Throwable)e);
            this.getRectSizeFromDisplay(activity, bounds);
        }
        catch (InvocationTargetException e) {
            Log.w((String)TAG, (Throwable)e);
            this.getRectSizeFromDisplay(activity, bounds);
        }
        WindowManager platformWindowManager = activity.getWindowManager();
        Display currentDisplay = platformWindowManager.getDefaultDisplay();
        Point realDisplaySize = new Point();
        Intrinsics.checkNotNullExpressionValue((Object)currentDisplay, (String)"currentDisplay");
        DisplayCompatHelperApi17.INSTANCE.getRealSize(currentDisplay, realDisplaySize);
        if (!ActivityCompatHelperApi24.INSTANCE.isInMultiWindowMode(activity)) {
            int navigationBarHeight = this.getNavigationBarHeight((Context)activity);
            if (bounds.bottom + navigationBarHeight == realDisplaySize.y) {
                bounds.bottom += navigationBarHeight;
            } else if (bounds.right + navigationBarHeight == realDisplaySize.x) {
                bounds.right += navigationBarHeight;
            } else if (bounds.left == navigationBarHeight) {
                bounds.left = 0;
            }
        }
        if (!(bounds.width() >= realDisplaySize.x && bounds.height() >= realDisplaySize.y || ActivityCompatHelperApi24.INSTANCE.isInMultiWindowMode(activity) || (displayCutout = this.getCutoutForDisplay(currentDisplay)) == null)) {
            if (bounds.left == DisplayCompatHelperApi28.INSTANCE.safeInsetLeft(displayCutout)) {
                bounds.left = 0;
            }
            if (realDisplaySize.x - bounds.right == DisplayCompatHelperApi28.INSTANCE.safeInsetRight(displayCutout)) {
                bounds.right += DisplayCompatHelperApi28.INSTANCE.safeInsetRight(displayCutout);
            }
            if (bounds.top == DisplayCompatHelperApi28.INSTANCE.safeInsetTop(displayCutout)) {
                bounds.top = 0;
            }
            if (realDisplaySize.y - bounds.bottom == DisplayCompatHelperApi28.INSTANCE.safeInsetBottom(displayCutout)) {
                bounds.bottom += DisplayCompatHelperApi28.INSTANCE.safeInsetBottom(displayCutout);
            }
        }
        return bounds;
    }

    private final void getRectSizeFromDisplay(Activity activity, Rect bounds) {
        Display defaultDisplay = activity.getWindowManager().getDefaultDisplay();
        defaultDisplay.getRectSize(bounds);
    }

    @RequiresApi(value=24)
    @NotNull
    public final Rect computeWindowBoundsN$window_release(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Rect bounds = new Rect();
        Display defaultDisplay = activity.getWindowManager().getDefaultDisplay();
        defaultDisplay.getRectSize(bounds);
        if (!ActivityCompatHelperApi24.INSTANCE.isInMultiWindowMode(activity)) {
            Intrinsics.checkNotNullExpressionValue((Object)defaultDisplay, (String)"defaultDisplay");
            Point realDisplaySize = this.getRealSizeForDisplay$window_release(defaultDisplay);
            int navigationBarHeight = this.getNavigationBarHeight((Context)activity);
            if (bounds.bottom + navigationBarHeight == realDisplaySize.y) {
                bounds.bottom += navigationBarHeight;
            } else if (bounds.right + navigationBarHeight == realDisplaySize.x) {
                bounds.right += navigationBarHeight;
            }
        }
        return bounds;
    }

    @RequiresApi(value=14)
    @NotNull
    public final Rect computeWindowBoundsIceCreamSandwich$window_release(@NotNull Activity activity) {
        Intrinsics.checkNotNullParameter((Object)activity, (String)"activity");
        Display defaultDisplay = activity.getWindowManager().getDefaultDisplay();
        Intrinsics.checkNotNullExpressionValue((Object)defaultDisplay, (String)"defaultDisplay");
        Point realDisplaySize = this.getRealSizeForDisplay$window_release(defaultDisplay);
        Rect bounds = new Rect();
        if (realDisplaySize.x == 0 || realDisplaySize.y == 0) {
            defaultDisplay.getRectSize(bounds);
        } else {
            bounds.right = realDisplaySize.x;
            bounds.bottom = realDisplaySize.y;
        }
        return bounds;
    }

    @VisibleForTesting
    @RequiresApi(value=14)
    @NotNull
    public final Point getRealSizeForDisplay$window_release(@NotNull Display display) {
        Intrinsics.checkNotNullParameter((Object)display, (String)"display");
        Point size = new Point();
        if (Build.VERSION.SDK_INT >= 17) {
            DisplayCompatHelperApi17.INSTANCE.getRealSize(display, size);
        } else {
            try {
                Object[] objectArray = new Class[]{Point.class};
                Method getRealSizeMethod = Display.class.getDeclaredMethod("getRealSize", (Class<?>[])objectArray);
                getRealSizeMethod.setAccessible(true);
                objectArray = new Object[]{size};
                getRealSizeMethod.invoke((Object)display, objectArray);
            }
            catch (NoSuchMethodException e) {
                Log.w((String)TAG, (Throwable)e);
            }
            catch (IllegalAccessException e) {
                Log.w((String)TAG, (Throwable)e);
            }
            catch (InvocationTargetException e) {
                Log.w((String)TAG, (Throwable)e);
            }
        }
        return size;
    }

    private final int getNavigationBarHeight(Context context) {
        Resources resources = context.getResources();
        int resourceId = resources.getIdentifier("navigation_bar_height", "dimen", "android");
        return resourceId > 0 ? resources.getDimensionPixelSize(resourceId) : 0;
    }

    @SuppressLint(value={"BanUncheckedReflection"})
    @RequiresApi(value=28)
    private final DisplayCutout getCutoutForDisplay(Display display) {
        DisplayCutout displayCutout = null;
        try {
            Class<?> displayInfoClass = Class.forName("android.view.DisplayInfo");
            Constructor<?> displayInfoConstructor = displayInfoClass.getConstructor(new Class[0]);
            displayInfoConstructor.setAccessible(true);
            Object displayInfo = displayInfoConstructor.newInstance(new Object[0]);
            Object[] objectArray = new Class[]{displayInfo.getClass()};
            Method getDisplayInfoMethod = display.getClass().getDeclaredMethod("getDisplayInfo", (Class<?>[])objectArray);
            getDisplayInfoMethod.setAccessible(true);
            objectArray = new Object[]{displayInfo};
            getDisplayInfoMethod.invoke((Object)display, objectArray);
            Field displayCutoutField = displayInfo.getClass().getDeclaredField("displayCutout");
            displayCutoutField.setAccessible(true);
            Object cutout = displayCutoutField.get(displayInfo);
            if (cutout instanceof DisplayCutout) {
                displayCutout = (DisplayCutout)cutout;
            }
        }
        catch (ClassNotFoundException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        catch (NoSuchFieldException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        catch (InstantiationException e) {
            Log.w((String)TAG, (Throwable)e);
        }
        return displayCutout;
    }

    static {
        String string = WindowMetricsCalculatorCompat.class.getSimpleName();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"WindowMetricsCalculatorC\u2026at::class.java.simpleName");
        TAG = string;
    }
}

