/*
 * Decompiled with CFR 0.152.
 */
package androidx.window.layout;

import android.annotation.SuppressLint;
import android.graphics.Rect;
import androidx.annotation.VisibleForTesting;
import androidx.window.core.Bounds;
import androidx.window.core.SpecificationComputer;
import androidx.window.layout.DisplayFeature;
import androidx.window.layout.FoldingFeature;
import androidx.window.layout.HardwareFoldingFeature;
import androidx.window.layout.SidecarAdapter;
import androidx.window.layout.WindowLayoutInfo;
import androidx.window.sidecar.SidecarDeviceState;
import androidx.window.sidecar.SidecarDisplayFeature;
import androidx.window.sidecar.SidecarWindowLayoutInfo;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u0000 \u00192\u00020\u0001:\u0001\u0019B\u000f\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001a\u0010\u0005\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\bJ\u001c\u0010\n\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u000b2\b\u0010\t\u001a\u0004\u0018\u00010\u000bH\u0002J(\u0010\f\u001a\u00020\u00062\u000e\u0010\u0007\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\r2\u000e\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\rH\u0002J\u001a\u0010\u000e\u001a\u00020\u00062\b\u0010\u0007\u001a\u0004\u0018\u00010\u000f2\b\u0010\t\u001a\u0004\u0018\u00010\u000fJ\u001f\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u0013\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\u0014J\u0018\u0010\u0010\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u000f2\u0006\u0010\u0017\u001a\u00020\bJ\"\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\u00110\r2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u000b0\r2\u0006\u0010\u0013\u001a\u00020\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Landroidx/window/layout/SidecarAdapter;", "", "verificationMode", "Landroidx/window/core/SpecificationComputer$VerificationMode;", "(Landroidx/window/core/SpecificationComputer$VerificationMode;)V", "isEqualSidecarDeviceState", "", "first", "Landroidx/window/sidecar/SidecarDeviceState;", "second", "isEqualSidecarDisplayFeature", "Landroidx/window/sidecar/SidecarDisplayFeature;", "isEqualSidecarDisplayFeatures", "", "isEqualSidecarWindowLayoutInfo", "Landroidx/window/sidecar/SidecarWindowLayoutInfo;", "translate", "Landroidx/window/layout/DisplayFeature;", "feature", "deviceState", "translate$window_release", "Landroidx/window/layout/WindowLayoutInfo;", "extensionInfo", "state", "sidecarDisplayFeatures", "Companion", "window_release"})
public final class SidecarAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final SpecificationComputer.VerificationMode verificationMode;
    private static final String TAG = SidecarAdapter.class.getSimpleName();

    public SidecarAdapter(@NotNull SpecificationComputer.VerificationMode verificationMode) {
        Intrinsics.checkNotNullParameter((Object)((Object)verificationMode), (String)"verificationMode");
        this.verificationMode = verificationMode;
    }

    public /* synthetic */ SidecarAdapter(SpecificationComputer.VerificationMode verificationMode, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            verificationMode = SpecificationComputer.VerificationMode.QUIET;
        }
        this(verificationMode);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<DisplayFeature> translate(@NotNull List<SidecarDisplayFeature> sidecarDisplayFeatures, @NotNull SidecarDeviceState deviceState) {
        void $this$mapNotNullTo$iv$iv;
        Intrinsics.checkNotNullParameter(sidecarDisplayFeatures, (String)"sidecarDisplayFeatures");
        Intrinsics.checkNotNullParameter((Object)deviceState, (String)"deviceState");
        Iterable $this$mapNotNull$iv = sidecarDisplayFeatures;
        boolean $i$f$mapNotNull = false;
        Iterable iterable = $this$mapNotNull$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$mapNotNullTo = false;
        void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv$iv$iv.iterator();
        while (iterator.hasNext()) {
            DisplayFeature it$iv$iv;
            Object element$iv$iv$iv;
            Object element$iv$iv = element$iv$iv$iv = iterator.next();
            boolean bl = false;
            SidecarDisplayFeature sidecarFeature = (SidecarDisplayFeature)element$iv$iv;
            boolean bl2 = false;
            if (this.translate$window_release(sidecarFeature, deviceState) == null) continue;
            boolean bl3 = false;
            destination$iv$iv.add(it$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    @NotNull
    public final WindowLayoutInfo translate(@Nullable SidecarWindowLayoutInfo extensionInfo, @NotNull SidecarDeviceState state) {
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        if (extensionInfo == null) {
            return new WindowLayoutInfo(CollectionsKt.emptyList());
        }
        SidecarDeviceState deviceState = new SidecarDeviceState();
        int devicePosture = Companion.getSidecarDevicePosture$window_release(state);
        Companion.setSidecarDevicePosture(deviceState, devicePosture);
        List<SidecarDisplayFeature> sidecarDisplayFeatures = Companion.getSidecarDisplayFeatures(extensionInfo);
        List<DisplayFeature> displayFeatures = this.translate(sidecarDisplayFeatures, deviceState);
        return new WindowLayoutInfo(displayFeatures);
    }

    public final boolean isEqualSidecarDeviceState(@Nullable SidecarDeviceState first, @Nullable SidecarDeviceState second) {
        int secondPosture;
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return true;
        }
        if (first == null) {
            return false;
        }
        if (second == null) {
            return false;
        }
        int firstPosture = Companion.getSidecarDevicePosture$window_release(first);
        return firstPosture == (secondPosture = Companion.getSidecarDevicePosture$window_release(second));
    }

    public final boolean isEqualSidecarWindowLayoutInfo(@Nullable SidecarWindowLayoutInfo first, @Nullable SidecarWindowLayoutInfo second) {
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return true;
        }
        if (first == null) {
            return false;
        }
        if (second == null) {
            return false;
        }
        List<SidecarDisplayFeature> firstDisplayFeatures = Companion.getSidecarDisplayFeatures(first);
        List<SidecarDisplayFeature> secondDisplayFeatures = Companion.getSidecarDisplayFeatures(second);
        return this.isEqualSidecarDisplayFeatures(firstDisplayFeatures, secondDisplayFeatures);
    }

    private final boolean isEqualSidecarDisplayFeatures(List<SidecarDisplayFeature> first, List<SidecarDisplayFeature> second) {
        if (first == second) {
            return true;
        }
        if (first == null) {
            return false;
        }
        if (second == null) {
            return false;
        }
        if (first.size() != second.size()) {
            return false;
        }
        int n = 0;
        int n2 = first.size();
        while (n < n2) {
            SidecarDisplayFeature secondFeature;
            int i;
            SidecarDisplayFeature firstFeature;
            if (this.isEqualSidecarDisplayFeature(firstFeature = first.get(i = n++), secondFeature = second.get(i))) continue;
            return false;
        }
        return true;
    }

    private final boolean isEqualSidecarDisplayFeature(SidecarDisplayFeature first, SidecarDisplayFeature second) {
        if (Intrinsics.areEqual((Object)first, (Object)second)) {
            return true;
        }
        if (first == null) {
            return false;
        }
        if (second == null) {
            return false;
        }
        if (first.getType() != second.getType()) {
            return false;
        }
        return Intrinsics.areEqual((Object)first.getRect(), (Object)second.getRect());
    }

    @Nullable
    public final DisplayFeature translate$window_release(@NotNull SidecarDisplayFeature feature, @NotNull SidecarDeviceState deviceState) {
        FoldingFeature.State state;
        HardwareFoldingFeature.Type type;
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        Intrinsics.checkNotNullParameter((Object)deviceState, (String)"deviceState");
        String string = TAG;
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"TAG");
        SidecarDisplayFeature sidecarDisplayFeature = (SidecarDisplayFeature)SpecificationComputer.Companion.startSpecification$default(SpecificationComputer.Companion, feature, string, this.verificationMode, null, 4, null).require("Type must be either TYPE_FOLD or TYPE_HINGE", translate.checkedFeature.1.INSTANCE).require("Feature bounds must not be 0", translate.checkedFeature.2.INSTANCE).require("TYPE_FOLD must have 0 area", translate.checkedFeature.3.INSTANCE).require("Feature be pinned to either left or top", translate.checkedFeature.4.INSTANCE).compute();
        if (sidecarDisplayFeature == null) {
            return null;
        }
        SidecarDisplayFeature checkedFeature2 = sidecarDisplayFeature;
        switch (checkedFeature2.getType()) {
            case 1: {
                type = HardwareFoldingFeature.Type.Companion.getFOLD();
                break;
            }
            case 2: {
                type = HardwareFoldingFeature.Type.Companion.getHINGE();
                break;
            }
            default: {
                return null;
            }
        }
        HardwareFoldingFeature.Type type2 = type;
        switch (Companion.getSidecarDevicePosture$window_release(deviceState)) {
            case 0: 
            case 1: 
            case 4: {
                return null;
            }
            case 2: {
                state = FoldingFeature.State.HALF_OPENED;
                break;
            }
            case 3: {
                state = FoldingFeature.State.FLAT;
                break;
            }
            default: {
                state = FoldingFeature.State.FLAT;
            }
        }
        FoldingFeature.State state2 = state;
        Rect rect = feature.getRect();
        Intrinsics.checkNotNullExpressionValue((Object)rect, (String)"feature.rect");
        return new HardwareFoldingFeature(new Bounds(rect), type2, state2);
    }

    public SidecarAdapter() {
        this(null, 1, null);
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0007J\u0015\u0010\n\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0000\u00a2\u0006\u0002\b\u000bJ\u0016\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u000e0\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0007J\u0018\u0010\u0011\u001a\u00020\u00122\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0013\u001a\u00020\u0007H\u0007J \u0010\u0014\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u00102\u000e\u0010\u0015\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u000e0\rH\u0007R\u0016\u0010\u0003\u001a\n \u0005*\u0004\u0018\u00010\u00040\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/window/layout/SidecarAdapter$Companion;", "", "()V", "TAG", "", "kotlin.jvm.PlatformType", "getRawSidecarDevicePosture", "", "sidecarDeviceState", "Landroidx/window/sidecar/SidecarDeviceState;", "getSidecarDevicePosture", "getSidecarDevicePosture$window_release", "getSidecarDisplayFeatures", "", "Landroidx/window/sidecar/SidecarDisplayFeature;", "info", "Landroidx/window/sidecar/SidecarWindowLayoutInfo;", "setSidecarDevicePosture", "", "posture", "setSidecarDisplayFeatures", "displayFeatures", "window_release"})
    public static final class Companion {
        private Companion() {
        }

        @SuppressLint(value={"BanUncheckedReflection"})
        @VisibleForTesting
        @NotNull
        public final List<SidecarDisplayFeature> getSidecarDisplayFeatures(@NotNull SidecarWindowLayoutInfo info) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            try {
                List list = info.displayFeatures;
                if (list == null) {
                    list = CollectionsKt.emptyList();
                }
                return list;
            }
            catch (NoSuchFieldError error) {
                try {
                    Method methodGetFeatures = SidecarWindowLayoutInfo.class.getMethod("getDisplayFeatures", new Class[0]);
                    Object object = methodGetFeatures.invoke((Object)info, new Object[0]);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.collections.List<androidx.window.sidecar.SidecarDisplayFeature>");
                    }
                    return (List)object;
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                }
                return CollectionsKt.emptyList();
            }
        }

        @SuppressLint(value={"BanUncheckedReflection"})
        @VisibleForTesting
        public final void setSidecarDisplayFeatures(@NotNull SidecarWindowLayoutInfo info, @NotNull List<SidecarDisplayFeature> displayFeatures) {
            Intrinsics.checkNotNullParameter((Object)info, (String)"info");
            Intrinsics.checkNotNullParameter(displayFeatures, (String)"displayFeatures");
            try {
                info.displayFeatures = displayFeatures;
            }
            catch (NoSuchFieldError error) {
                try {
                    Object[] objectArray = new Class[]{List.class};
                    Method methodSetFeatures = SidecarWindowLayoutInfo.class.getMethod("setDisplayFeatures", (Class<?>[])objectArray);
                    objectArray = new Object[]{displayFeatures};
                    methodSetFeatures.invoke((Object)info, objectArray);
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                }
            }
        }

        public final int getSidecarDevicePosture$window_release(@NotNull SidecarDeviceState sidecarDeviceState) {
            Intrinsics.checkNotNullParameter((Object)sidecarDeviceState, (String)"sidecarDeviceState");
            int rawPosture = this.getRawSidecarDevicePosture(sidecarDeviceState);
            return rawPosture < 0 || rawPosture > 4 ? 0 : rawPosture;
        }

        @SuppressLint(value={"BanUncheckedReflection"})
        @VisibleForTesting
        public final int getRawSidecarDevicePosture(@NotNull SidecarDeviceState sidecarDeviceState) {
            Intrinsics.checkNotNullParameter((Object)sidecarDeviceState, (String)"sidecarDeviceState");
            try {
                return sidecarDeviceState.posture;
            }
            catch (NoSuchFieldError error) {
                try {
                    Method methodGetPosture = SidecarDeviceState.class.getMethod("getPosture", new Class[0]);
                    Object object = methodGetPosture.invoke((Object)sidecarDeviceState, new Object[0]);
                    if (object == null) {
                        throw new NullPointerException("null cannot be cast to non-null type kotlin.Int");
                    }
                    return (Integer)object;
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                }
                return 0;
            }
        }

        @SuppressLint(value={"BanUncheckedReflection"})
        @VisibleForTesting
        public final void setSidecarDevicePosture(@NotNull SidecarDeviceState sidecarDeviceState, int posture) {
            Intrinsics.checkNotNullParameter((Object)sidecarDeviceState, (String)"sidecarDeviceState");
            try {
                sidecarDeviceState.posture = posture;
            }
            catch (NoSuchFieldError error) {
                try {
                    Object[] objectArray = new Class[]{Integer.TYPE};
                    Method methodSetPosture = SidecarDeviceState.class.getMethod("setPosture", (Class<?>[])objectArray);
                    objectArray = new Object[]{posture};
                    methodSetPosture.invoke((Object)sidecarDeviceState, objectArray);
                }
                catch (NoSuchMethodException e) {
                }
                catch (IllegalAccessException e) {
                }
                catch (InvocationTargetException e) {
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

