/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.datepicker;

import android.content.Context;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextWatcher;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.util.Pair;
import com.google.android.material.R;
import com.google.android.material.datepicker.CalendarConstraints;
import com.google.android.material.datepicker.DateFormatTextWatcher;
import com.google.android.material.datepicker.DateSelector;
import com.google.android.material.datepicker.DateStrings;
import com.google.android.material.datepicker.MaterialDatePicker;
import com.google.android.material.datepicker.OnSelectionChangedListener;
import com.google.android.material.datepicker.UtcDates;
import com.google.android.material.internal.ManufacturerUtils;
import com.google.android.material.internal.ViewUtils;
import com.google.android.material.resources.MaterialAttributes;
import com.google.android.material.textfield.TextInputLayout;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class SingleDateSelector
implements DateSelector<Long> {
    @Nullable
    private Long selectedItem;
    public static final Parcelable.Creator<SingleDateSelector> CREATOR = new Parcelable.Creator<SingleDateSelector>(){

        @NonNull
        public SingleDateSelector createFromParcel(@NonNull Parcel source) {
            SingleDateSelector singleDateSelector = new SingleDateSelector();
            singleDateSelector.selectedItem = (Long)source.readValue(Long.class.getClassLoader());
            return singleDateSelector;
        }

        @NonNull
        public SingleDateSelector[] newArray(int size) {
            return new SingleDateSelector[size];
        }
    };

    @Override
    public void select(long selection) {
        this.selectedItem = selection;
    }

    private void clearSelection() {
        this.selectedItem = null;
    }

    @Override
    public void setSelection(@Nullable Long selection) {
        this.selectedItem = selection == null ? null : Long.valueOf(UtcDates.canonicalYearMonthDay(selection));
    }

    @Override
    public boolean isSelectionComplete() {
        return this.selectedItem != null;
    }

    @Override
    @NonNull
    public Collection<Pair<Long, Long>> getSelectedRanges() {
        return new ArrayList<Pair<Long, Long>>();
    }

    @Override
    @NonNull
    public Collection<Long> getSelectedDays() {
        ArrayList<Long> selections = new ArrayList<Long>();
        if (this.selectedItem != null) {
            selections.add(this.selectedItem);
        }
        return selections;
    }

    @Override
    @Nullable
    public Long getSelection() {
        return this.selectedItem;
    }

    @Override
    public View onCreateTextInputView(@NonNull LayoutInflater layoutInflater, @Nullable ViewGroup viewGroup, @Nullable Bundle bundle, CalendarConstraints constraints, final @NonNull OnSelectionChangedListener<Long> listener) {
        View root = layoutInflater.inflate(R.layout.mtrl_picker_text_input_date, viewGroup, false);
        TextInputLayout dateTextInput = (TextInputLayout)root.findViewById(R.id.mtrl_picker_text_input_date);
        EditText dateEditText = dateTextInput.getEditText();
        if (ManufacturerUtils.isDateInputKeyboardMissingSeparatorCharacters()) {
            dateEditText.setInputType(17);
        }
        SimpleDateFormat format = UtcDates.getTextInputFormat();
        String formatHint = UtcDates.getTextInputHint(root.getResources(), format);
        dateTextInput.setPlaceholderText(formatHint);
        if (this.selectedItem != null) {
            dateEditText.setText((CharSequence)format.format(this.selectedItem));
        }
        dateEditText.addTextChangedListener((TextWatcher)new DateFormatTextWatcher(formatHint, format, dateTextInput, constraints){

            @Override
            void onValidDate(@Nullable Long day) {
                if (day == null) {
                    SingleDateSelector.this.clearSelection();
                } else {
                    SingleDateSelector.this.select(day);
                }
                listener.onSelectionChanged(SingleDateSelector.this.getSelection());
            }

            @Override
            void onInvalidDate() {
                listener.onIncompleteSelectionChanged();
            }
        });
        ViewUtils.requestFocusAndShowKeyboard((View)dateEditText);
        return root;
    }

    @Override
    public int getDefaultThemeResId(Context context) {
        return MaterialAttributes.resolveOrThrow(context, R.attr.materialCalendarTheme, MaterialDatePicker.class.getCanonicalName());
    }

    @Override
    @NonNull
    public String getSelectionDisplayString(@NonNull Context context) {
        Resources res = context.getResources();
        if (this.selectedItem == null) {
            return res.getString(R.string.mtrl_picker_date_header_unselected);
        }
        String startString = DateStrings.getYearMonthDay(this.selectedItem);
        return res.getString(R.string.mtrl_picker_date_header_selected, new Object[]{startString});
    }

    @Override
    public int getDefaultTitleResId() {
        return R.string.mtrl_picker_date_header_title;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(@NonNull Parcel dest, int flags) {
        dest.writeValue((Object)this.selectedItem);
    }
}

