/*
 * Decompiled with CFR 0.152.
 */
package androidx.fragment.app;

import android.os.Build;
import android.view.View;
import androidx.annotation.NonNull;
import androidx.collection.ArrayMap;
import androidx.core.app.SharedElementCallback;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentTransitionCompat21;
import androidx.fragment.app.FragmentTransitionImpl;
import java.util.ArrayList;

class FragmentTransition {
    static final FragmentTransitionImpl PLATFORM_IMPL = Build.VERSION.SDK_INT >= 21 ? new FragmentTransitionCompat21() : null;
    static final FragmentTransitionImpl SUPPORT_IMPL = FragmentTransition.resolveSupportImpl();

    private static FragmentTransitionImpl resolveSupportImpl() {
        try {
            Class<?> impl = Class.forName("androidx.transition.FragmentTransitionSupport");
            return (FragmentTransitionImpl)impl.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (Exception exception) {
            return null;
        }
    }

    static String findKeyForValue(ArrayMap<String, String> map, String value) {
        int numElements = map.size();
        for (int i = 0; i < numElements; ++i) {
            if (!value.equals(map.valueAt(i))) continue;
            return (String)map.keyAt(i);
        }
        return null;
    }

    static void retainValues(@NonNull ArrayMap<String, String> nameOverrides, @NonNull ArrayMap<String, View> namedViews) {
        for (int i = nameOverrides.size() - 1; i >= 0; --i) {
            String targetName = (String)nameOverrides.valueAt(i);
            if (namedViews.containsKey((Object)targetName)) continue;
            nameOverrides.removeAt(i);
        }
    }

    static void callSharedElementStartEnd(Fragment inFragment, Fragment outFragment, boolean isPop, ArrayMap<String, View> sharedElements, boolean isStart) {
        SharedElementCallback sharedElementCallback;
        SharedElementCallback sharedElementCallback2 = sharedElementCallback = isPop ? outFragment.getEnterTransitionCallback() : inFragment.getEnterTransitionCallback();
        if (sharedElementCallback != null) {
            ArrayList<View> views = new ArrayList<View>();
            ArrayList<String> names = new ArrayList<String>();
            int count = sharedElements == null ? 0 : sharedElements.size();
            for (int i = 0; i < count; ++i) {
                names.add((String)sharedElements.keyAt(i));
                views.add((View)sharedElements.valueAt(i));
            }
            if (isStart) {
                sharedElementCallback.onSharedElementStart(names, views, null);
            } else {
                sharedElementCallback.onSharedElementEnd(names, views, null);
            }
        }
    }

    static void setViewVisibility(ArrayList<View> views, int visibility) {
        if (views == null) {
            return;
        }
        for (int i = views.size() - 1; i >= 0; --i) {
            View view = views.get(i);
            view.setVisibility(visibility);
        }
    }

    static boolean supportsTransition() {
        return PLATFORM_IMPL != null || SUPPORT_IMPL != null;
    }

    private FragmentTransition() {
    }
}

