/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.maui;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Typeface;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.appcompat.R;
import androidx.appcompat.widget.SearchView;
import androidx.appcompat.widget.TintTypedArray;
import androidx.coordinatorlayout.widget.CoordinatorLayout;
import androidx.recyclerview.widget.RecyclerView;
import androidx.viewpager2.adapter.FragmentStateAdapter;
import androidx.viewpager2.widget.ViewPager2;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.target.Target;
import com.google.android.material.appbar.AppBarLayout;
import com.google.android.material.appbar.MaterialToolbar;
import com.google.android.material.bottomnavigation.BottomNavigationView;
import com.google.android.material.navigation.NavigationBarView;
import com.google.android.material.tabs.TabLayout;
import com.google.android.material.tabs.TabLayoutMediator;
import com.microsoft.maui.ImageLoaderCallback;
import com.microsoft.maui.R;
import com.microsoft.maui.glide.MauiCustomTarget;
import com.microsoft.maui.glide.MauiCustomViewTarget;
import com.microsoft.maui.glide.font.FontModel;
import java.io.InputStream;

public class PlatformInterop {
    public static void requestLayoutIfNeeded(View view) {
        if (!view.isInLayout()) {
            view.requestLayout();
        }
    }

    public static void removeFromParent(View view) {
        ViewParent parent = view.getParent();
        if (parent == null) {
            return;
        }
        ((ViewGroup)parent).removeView(view);
    }

    public static void setPivotXIfNeeded(View view, float pivotX) {
        if (view.getPivotX() != pivotX) {
            view.setPivotX(pivotX);
        }
    }

    public static void setPivotYIfNeeded(View view, float pivotY) {
        if (view.getPivotY() != pivotY) {
            view.setPivotY(pivotY);
        }
    }

    public static void setContentDescriptionForAutomationId(View view, String description) {
        view = PlatformInterop.getSemanticPlatformElement(view);
        int importantForAccessibility = view.getImportantForAccessibility();
        view.setContentDescription((CharSequence)description);
        if (importantForAccessibility == 0) {
            view.setImportantForAccessibility(0);
        }
    }

    public static View getSemanticPlatformElement(View view) {
        if (view instanceof SearchView) {
            view = view.findViewById(R.id.search_button);
        }
        return view;
    }

    public static void set(View view, int visibility, int layoutDirection, int minimumHeight, int minimumWidth, boolean enabled, float alpha, float translationX, float translationY, float scaleX, float scaleY, float rotation, float rotationX, float rotationY, float pivotX, float pivotY) {
        PlatformInterop.requestLayoutIfNeeded(view);
        view.setVisibility(visibility);
        view.setLayoutDirection(layoutDirection);
        view.setMinimumHeight(minimumHeight);
        view.setMinimumWidth(minimumWidth);
        view.setEnabled(enabled);
        view.setAlpha(alpha);
        view.setTranslationX(translationX);
        view.setTranslationY(translationY);
        view.setScaleX(scaleX);
        view.setScaleY(scaleY);
        view.setRotation(rotation);
        view.setRotationX(rotationX);
        view.setRotationY(rotationY);
        PlatformInterop.setPivotXIfNeeded(view, pivotX);
        PlatformInterop.setPivotYIfNeeded(view, pivotY);
    }

    @NonNull
    public static LinearLayout createNavigationBarOuterLayout(Context context) {
        LinearLayout linearLayout = new LinearLayout(context);
        linearLayout.setOrientation(1);
        linearLayout.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -1));
        return linearLayout;
    }

    @NonNull
    public static FrameLayout createNavigationBarArea(Context context, LinearLayout linearLayout) {
        FrameLayout frameLayout = new FrameLayout(context);
        frameLayout.setId(View.generateViewId());
        LinearLayout.LayoutParams layoutParams = new LinearLayout.LayoutParams(-1, 0);
        layoutParams.gravity = 119;
        layoutParams.weight = 1.0f;
        frameLayout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        linearLayout.addView((View)frameLayout);
        return frameLayout;
    }

    @NonNull
    public static BottomNavigationView createNavigationBar(Context context, int styleAttribute, LinearLayout linearLayout, NavigationBarView.OnItemSelectedListener listener) {
        BottomNavigationView navigationView = new BottomNavigationView(context, null, styleAttribute);
        navigationView.setLayoutParams((ViewGroup.LayoutParams)new LinearLayout.LayoutParams(-1, -2));
        navigationView.setBackgroundColor(-1);
        navigationView.setOnItemSelectedListener(listener);
        linearLayout.addView((View)navigationView);
        return navigationView;
    }

    @NonNull
    public static MaterialToolbar createToolbar(Context context, int actionBarHeight, int popupTheme) {
        MaterialToolbar toolbar = new MaterialToolbar(context);
        AppBarLayout.LayoutParams layoutParams = new AppBarLayout.LayoutParams(-1, actionBarHeight);
        layoutParams.setScrollFlags(0);
        toolbar.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        if (popupTheme > 0) {
            toolbar.setPopupTheme(popupTheme);
        }
        return toolbar;
    }

    @NonNull
    public static CoordinatorLayout createShellCoordinatorLayout(Context context) {
        CoordinatorLayout layout = new CoordinatorLayout(context);
        layout.setLayoutParams(new ViewGroup.LayoutParams(-1, -1));
        return layout;
    }

    @NonNull
    public static AppBarLayout createShellAppBar(Context context, int appBarStyleAttribute, CoordinatorLayout layout) {
        AppBarLayout appbar = new AppBarLayout(context, null, appBarStyleAttribute);
        appbar.setLayoutParams(new ViewGroup.LayoutParams(-1, -2));
        layout.addView((View)appbar);
        return appbar;
    }

    @NonNull
    public static TabLayout createShellTabLayout(Context context, AppBarLayout appbar, int actionBarHeight) {
        TabLayout layout = new TabLayout(context);
        AppBarLayout.LayoutParams layoutParams = new AppBarLayout.LayoutParams(-1, actionBarHeight);
        layoutParams.gravity = 80;
        layout.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        layout.setTabMode(0);
        appbar.addView((View)layout);
        return layout;
    }

    @NonNull
    public static ViewPager2 createShellViewPager(Context context, CoordinatorLayout layout, TabLayout tabLayout, TabLayoutMediator.TabConfigurationStrategy tabConfigurationStrategy, FragmentStateAdapter adapter, ViewPager2.OnPageChangeCallback callback) {
        ViewPager2 pager = new ViewPager2(context);
        CoordinatorLayout.LayoutParams layoutParams = new CoordinatorLayout.LayoutParams(-1, -1);
        layoutParams.setBehavior((CoordinatorLayout.Behavior)new AppBarLayout.ScrollingViewBehavior());
        pager.setOverScrollMode(2);
        pager.setId(View.generateViewId());
        pager.setLayoutParams((ViewGroup.LayoutParams)layoutParams);
        pager.setAdapter((RecyclerView.Adapter)adapter);
        pager.registerOnPageChangeCallback(callback);
        layout.addView((View)pager);
        new TabLayoutMediator(tabLayout, pager, tabConfigurationStrategy).attach();
        return pager;
    }

    private static void prepare(RequestBuilder<Drawable> builder, Target<Drawable> target, Boolean cachingEnabled, ImageLoaderCallback callback) {
        builder = builder.error((Object)callback);
        if (!cachingEnabled.booleanValue()) {
            builder = (RequestBuilder)((RequestBuilder)builder.diskCacheStrategy(DiskCacheStrategy.NONE)).skipMemoryCache(true);
        }
        builder.into(target);
    }

    private static void loadInto(RequestBuilder<Drawable> builder, ImageView imageView, Boolean cachingEnabled, ImageLoaderCallback callback) {
        MauiCustomViewTarget target = new MauiCustomViewTarget(imageView, callback);
        PlatformInterop.prepare(builder, (Target<Drawable>)target, cachingEnabled, callback);
    }

    private static void load(RequestBuilder<Drawable> builder, Context context, Boolean cachingEnabled, ImageLoaderCallback callback) {
        MauiCustomTarget target = new MauiCustomTarget(context, callback);
        PlatformInterop.prepare(builder, (Target<Drawable>)target, cachingEnabled, callback);
    }

    public static void loadImageFromFile(ImageView imageView, String file, ImageLoaderCallback callback) {
        RequestBuilder builder = Glide.with((View)imageView).load(file);
        PlatformInterop.loadInto((RequestBuilder<Drawable>)builder, imageView, true, callback);
    }

    public static void loadImageFromUri(ImageView imageView, String uri, Boolean cachingEnabled, ImageLoaderCallback callback) {
        Uri androidUri = Uri.parse((String)uri);
        if (androidUri == null) {
            callback.onComplete(false, null, null);
            return;
        }
        RequestBuilder builder = Glide.with((View)imageView).load(androidUri);
        PlatformInterop.loadInto((RequestBuilder<Drawable>)builder, imageView, cachingEnabled, callback);
    }

    public static void loadImageFromStream(ImageView imageView, InputStream inputStream, ImageLoaderCallback callback) {
        RequestBuilder builder = Glide.with((View)imageView).load((Object)inputStream);
        PlatformInterop.loadInto((RequestBuilder<Drawable>)builder, imageView, true, callback);
    }

    public static void loadImageFromFont(ImageView imageView, @ColorInt int color, String glyph, Typeface typeface, float textSize, ImageLoaderCallback callback) {
        FontModel fontModel = new FontModel(color, glyph, textSize, typeface);
        RequestBuilder builder = (RequestBuilder)Glide.with((View)imageView).load((Object)fontModel).override(Integer.MIN_VALUE, Integer.MIN_VALUE);
        PlatformInterop.loadInto((RequestBuilder<Drawable>)builder, imageView, true, callback);
    }

    public static void loadImageFromFile(Context context, String file, ImageLoaderCallback callback) {
        RequestBuilder builder = Glide.with((Context)context).load(file);
        PlatformInterop.load((RequestBuilder<Drawable>)builder, context, true, callback);
    }

    public static void loadImageFromUri(Context context, String uri, Boolean cachingEnabled, ImageLoaderCallback callback) {
        Uri androidUri = Uri.parse((String)uri);
        if (androidUri == null) {
            callback.onComplete(false, null, null);
            return;
        }
        RequestBuilder builder = Glide.with((Context)context).load(androidUri);
        PlatformInterop.load((RequestBuilder<Drawable>)builder, context, cachingEnabled, callback);
    }

    public static void loadImageFromStream(Context context, InputStream inputStream, ImageLoaderCallback callback) {
        RequestBuilder builder = Glide.with((Context)context).load((Object)inputStream);
        PlatformInterop.load((RequestBuilder<Drawable>)builder, context, true, callback);
    }

    public static void loadImageFromFont(Context context, @ColorInt int color, String glyph, Typeface typeface, float textSize, ImageLoaderCallback callback) {
        FontModel fontModel = new FontModel(color, glyph, textSize, typeface);
        RequestBuilder builder = (RequestBuilder)Glide.with((Context)context).load((Object)fontModel).override(Integer.MIN_VALUE, Integer.MIN_VALUE);
        PlatformInterop.load((RequestBuilder<Drawable>)builder, context, true, callback);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ColorStateList getColorStateListForToolbarStyleableAttribute(Context context, int resId, int index) {
        TintTypedArray styledAttributes = TintTypedArray.obtainStyledAttributes((Context)context, null, (int[])R.styleable.Toolbar, (int)resId, (int)0);
        try {
            ColorStateList colorStateList = styledAttributes.getColorStateList(index);
            return colorStateList;
        }
        finally {
            styledAttributes.recycle();
        }
    }
}

