/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.content.Context;
import android.graphics.Typeface;
import android.text.TextPaint;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import com.google.android.material.resources.TextAppearance;
import com.google.android.material.resources.TextAppearanceFontCallback;
import java.lang.ref.WeakReference;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class TextDrawableHelper {
    private final TextPaint textPaint = new TextPaint(1);
    private final TextAppearanceFontCallback fontCallback = new TextAppearanceFontCallback(){

        @Override
        public void onFontRetrieved(@NonNull Typeface typeface, boolean fontResolvedSynchronously) {
            if (fontResolvedSynchronously) {
                return;
            }
            TextDrawableHelper.this.textWidthDirty = true;
            TextDrawableDelegate textDrawableDelegate = (TextDrawableDelegate)TextDrawableHelper.this.delegate.get();
            if (textDrawableDelegate != null) {
                textDrawableDelegate.onTextSizeChange();
            }
        }

        @Override
        public void onFontRetrievalFailed(int reason) {
            TextDrawableHelper.this.textWidthDirty = true;
            TextDrawableDelegate textDrawableDelegate = (TextDrawableDelegate)TextDrawableHelper.this.delegate.get();
            if (textDrawableDelegate != null) {
                textDrawableDelegate.onTextSizeChange();
            }
        }
    };
    private float textWidth;
    private boolean textWidthDirty = true;
    @Nullable
    private WeakReference<TextDrawableDelegate> delegate = new WeakReference<Object>(null);
    @Nullable
    private TextAppearance textAppearance;

    public TextDrawableHelper(@Nullable TextDrawableDelegate delegate) {
        this.setDelegate(delegate);
    }

    public void setDelegate(@Nullable TextDrawableDelegate delegate) {
        this.delegate = new WeakReference<TextDrawableDelegate>(delegate);
    }

    @NonNull
    public TextPaint getTextPaint() {
        return this.textPaint;
    }

    public void setTextWidthDirty(boolean dirty) {
        this.textWidthDirty = dirty;
    }

    public boolean isTextWidthDirty() {
        return this.textWidthDirty;
    }

    public float getTextWidth(String text) {
        if (!this.textWidthDirty) {
            return this.textWidth;
        }
        this.textWidth = this.calculateTextWidth(text);
        this.textWidthDirty = false;
        return this.textWidth;
    }

    private float calculateTextWidth(@Nullable CharSequence charSequence) {
        if (charSequence == null) {
            return 0.0f;
        }
        return this.textPaint.measureText(charSequence, 0, charSequence.length());
    }

    @Nullable
    public TextAppearance getTextAppearance() {
        return this.textAppearance;
    }

    public void setTextAppearance(@Nullable TextAppearance textAppearance, Context context) {
        if (this.textAppearance != textAppearance) {
            TextDrawableDelegate textDrawableDelegate;
            this.textAppearance = textAppearance;
            if (textAppearance != null) {
                textAppearance.updateMeasureState(context, this.textPaint, this.fontCallback);
                textDrawableDelegate = (TextDrawableDelegate)this.delegate.get();
                if (textDrawableDelegate != null) {
                    this.textPaint.drawableState = textDrawableDelegate.getState();
                }
                textAppearance.updateDrawState(context, this.textPaint, this.fontCallback);
                this.textWidthDirty = true;
            }
            if ((textDrawableDelegate = (TextDrawableDelegate)this.delegate.get()) != null) {
                textDrawableDelegate.onTextSizeChange();
                textDrawableDelegate.onStateChange(textDrawableDelegate.getState());
            }
        }
    }

    public void updateTextPaintDrawState(Context context) {
        this.textAppearance.updateDrawState(context, this.textPaint, this.fontCallback);
    }

    public static interface TextDrawableDelegate {
        @NonNull
        public int[] getState();

        public void onTextSizeChange();

        public boolean onStateChange(int[] var1);
    }
}

