/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.internal;

import android.annotation.TargetApi;
import android.content.Context;
import android.os.Build;
import android.view.View;
import android.view.Window;
import androidx.annotation.ColorInt;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.core.graphics.ColorUtils;
import androidx.core.view.WindowCompat;
import androidx.core.view.WindowInsetsControllerCompat;
import com.google.android.material.color.MaterialColors;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public class EdgeToEdgeUtils {
    private static final int EDGE_TO_EDGE_BAR_ALPHA = 128;

    private EdgeToEdgeUtils() {
    }

    public static void applyEdgeToEdge(@NonNull Window window, boolean edgeToEdgeEnabled) {
        EdgeToEdgeUtils.applyEdgeToEdge(window, edgeToEdgeEnabled, null, null);
    }

    public static void applyEdgeToEdge(@NonNull Window window, boolean edgeToEdgeEnabled, @Nullable @ColorInt Integer statusBarOverlapBackgroundColor, @Nullable @ColorInt Integer navigationBarOverlapBackgroundColor) {
        boolean useDefaultBackgroundColorForNavigationBar;
        if (Build.VERSION.SDK_INT < 21) {
            return;
        }
        boolean useDefaultBackgroundColorForStatusBar = statusBarOverlapBackgroundColor == null || statusBarOverlapBackgroundColor == 0;
        boolean bl = useDefaultBackgroundColorForNavigationBar = navigationBarOverlapBackgroundColor == null || navigationBarOverlapBackgroundColor == 0;
        if (useDefaultBackgroundColorForStatusBar || useDefaultBackgroundColorForNavigationBar) {
            int defaultBackgroundColor = MaterialColors.getColor(window.getContext(), 0x1010031, -16777216);
            if (useDefaultBackgroundColorForStatusBar) {
                statusBarOverlapBackgroundColor = defaultBackgroundColor;
            }
            if (useDefaultBackgroundColorForNavigationBar) {
                navigationBarOverlapBackgroundColor = defaultBackgroundColor;
            }
        }
        WindowCompat.setDecorFitsSystemWindows((Window)window, (!edgeToEdgeEnabled ? 1 : 0) != 0);
        int statusBarColor = EdgeToEdgeUtils.getStatusBarColor(window.getContext(), edgeToEdgeEnabled);
        int navigationBarColor = EdgeToEdgeUtils.getNavigationBarColor(window.getContext(), edgeToEdgeEnabled);
        window.setStatusBarColor(statusBarColor);
        window.setNavigationBarColor(navigationBarColor);
        boolean isLightStatusBar = EdgeToEdgeUtils.isUsingLightSystemBar(statusBarColor, MaterialColors.isColorLight(statusBarOverlapBackgroundColor));
        boolean isLightNavigationBar = EdgeToEdgeUtils.isUsingLightSystemBar(navigationBarColor, MaterialColors.isColorLight(navigationBarOverlapBackgroundColor));
        WindowInsetsControllerCompat insetsController = WindowCompat.getInsetsController((Window)window, (View)window.getDecorView());
        if (insetsController != null) {
            insetsController.setAppearanceLightStatusBars(isLightStatusBar);
            insetsController.setAppearanceLightNavigationBars(isLightNavigationBar);
        }
    }

    @TargetApi(value=21)
    private static int getStatusBarColor(Context context, boolean isEdgeToEdgeEnabled) {
        if (isEdgeToEdgeEnabled && Build.VERSION.SDK_INT < 23) {
            int opaqueStatusBarColor = MaterialColors.getColor(context, 16843857, -16777216);
            return ColorUtils.setAlphaComponent((int)opaqueStatusBarColor, (int)128);
        }
        if (isEdgeToEdgeEnabled) {
            return 0;
        }
        return MaterialColors.getColor(context, 16843857, -16777216);
    }

    @TargetApi(value=21)
    private static int getNavigationBarColor(Context context, boolean isEdgeToEdgeEnabled) {
        if (isEdgeToEdgeEnabled && Build.VERSION.SDK_INT < 27) {
            int opaqueNavBarColor = MaterialColors.getColor(context, 16843858, -16777216);
            return ColorUtils.setAlphaComponent((int)opaqueNavBarColor, (int)128);
        }
        if (isEdgeToEdgeEnabled) {
            return 0;
        }
        return MaterialColors.getColor(context, 16843858, -16777216);
    }

    private static boolean isUsingLightSystemBar(int systemBarColor, boolean isLightBackground) {
        return MaterialColors.isColorLight(systemBarColor) || systemBarColor == 0 && isLightBackground;
    }
}

