/*
 * Decompiled with CFR 0.152.
 */
package androidx.constraintlayout.motion.widget;

import android.content.Context;
import android.util.AttributeSet;
import androidx.constraintlayout.motion.utils.ViewSpline;
import androidx.constraintlayout.widget.ConstraintAttribute;
import java.util.HashMap;
import java.util.HashSet;

public abstract class Key {
    public static int UNSET = -1;
    int mFramePosition = UNSET;
    int mTargetId = UNSET;
    String mTargetString = null;
    protected int mType;
    HashMap<String, ConstraintAttribute> mCustomConstraints;
    public static final String ALPHA = "alpha";
    public static final String ELEVATION = "elevation";
    public static final String ROTATION = "rotation";
    public static final String ROTATION_X = "rotationX";
    public static final String ROTATION_Y = "rotationY";
    public static final String PIVOT_X = "transformPivotX";
    public static final String PIVOT_Y = "transformPivotY";
    public static final String TRANSITION_PATH_ROTATE = "transitionPathRotate";
    public static final String SCALE_X = "scaleX";
    public static final String SCALE_Y = "scaleY";
    public static final String WAVE_PERIOD = "wavePeriod";
    public static final String WAVE_OFFSET = "waveOffset";
    public static final String WAVE_PHASE = "wavePhase";
    public static final String WAVE_VARIES_BY = "waveVariesBy";
    public static final String TRANSLATION_X = "translationX";
    public static final String TRANSLATION_Y = "translationY";
    public static final String TRANSLATION_Z = "translationZ";
    public static final String PROGRESS = "progress";
    public static final String CUSTOM = "CUSTOM";
    public static final String CURVEFIT = "curveFit";
    public static final String MOTIONPROGRESS = "motionProgress";
    public static final String TRANSITIONEASING = "transitionEasing";
    public static final String VISIBILITY = "visibility";

    abstract void load(Context var1, AttributeSet var2);

    abstract void getAttributeNames(HashSet<String> var1);

    boolean matches(String constraintTag) {
        if (this.mTargetString == null || constraintTag == null) {
            return false;
        }
        return constraintTag.matches(this.mTargetString);
    }

    public abstract void addValues(HashMap<String, ViewSpline> var1);

    public abstract void setValue(String var1, Object var2);

    float toFloat(Object value) {
        return value instanceof Float ? ((Float)value).floatValue() : Float.parseFloat(value.toString());
    }

    int toInt(Object value) {
        return value instanceof Integer ? (Integer)value : Integer.parseInt(value.toString());
    }

    boolean toBoolean(Object value) {
        return value instanceof Boolean ? (Boolean)value : Boolean.parseBoolean(value.toString());
    }

    public void setInterpolation(HashMap<String, Integer> interpolation) {
    }

    public Key copy(Key src) {
        this.mFramePosition = src.mFramePosition;
        this.mTargetId = src.mTargetId;
        this.mTargetString = src.mTargetString;
        this.mType = src.mType;
        this.mCustomConstraints = src.mCustomConstraints;
        return this;
    }

    public abstract Key clone();

    public Key setViewId(int id2) {
        this.mTargetId = id2;
        return this;
    }

    public void setFramePosition(int pos) {
        this.mFramePosition = pos;
    }

    public int getFramePosition() {
        return this.mFramePosition;
    }
}

