/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.shape;

import android.annotation.TargetApi;
import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Outline;
import android.graphics.Paint;
import android.graphics.Path;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffColorFilter;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.Region;
import android.graphics.Xfermode;
import android.graphics.drawable.Drawable;
import android.os.Build;
import android.os.Looper;
import android.util.AttributeSet;
import android.util.Log;
import androidx.annotation.AttrRes;
import androidx.annotation.ColorInt;
import androidx.annotation.IntRange;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.RestrictTo;
import androidx.annotation.StyleRes;
import androidx.core.graphics.drawable.TintAwareDrawable;
import androidx.core.util.ObjectsCompat;
import com.google.android.material.R;
import com.google.android.material.color.MaterialColors;
import com.google.android.material.elevation.ElevationOverlayProvider;
import com.google.android.material.shadow.ShadowRenderer;
import com.google.android.material.shape.AdjustedCornerSize;
import com.google.android.material.shape.CornerSize;
import com.google.android.material.shape.RelativeCornerSize;
import com.google.android.material.shape.ShapeAppearanceModel;
import com.google.android.material.shape.ShapeAppearancePathProvider;
import com.google.android.material.shape.ShapePath;
import com.google.android.material.shape.ShapePathModel;
import com.google.android.material.shape.Shapeable;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.util.BitSet;

public class MaterialShapeDrawable
extends Drawable
implements TintAwareDrawable,
Shapeable {
    private static final String TAG = MaterialShapeDrawable.class.getSimpleName();
    private static final float SHADOW_RADIUS_MULTIPLIER = 0.75f;
    private static final float SHADOW_OFFSET_MULTIPLIER = 0.25f;
    public static final int SHADOW_COMPAT_MODE_DEFAULT = 0;
    public static final int SHADOW_COMPAT_MODE_NEVER = 1;
    public static final int SHADOW_COMPAT_MODE_ALWAYS = 2;
    private static final Paint clearPaint = new Paint(1);
    private MaterialShapeDrawableState drawableState;
    private final ShapePath.ShadowCompatOperation[] cornerShadowOperation = new ShapePath.ShadowCompatOperation[4];
    private final ShapePath.ShadowCompatOperation[] edgeShadowOperation = new ShapePath.ShadowCompatOperation[4];
    private final BitSet containsIncompatibleShadowOp = new BitSet(8);
    private boolean pathDirty;
    private final Matrix matrix = new Matrix();
    private final Path path = new Path();
    private final Path pathInsetByStroke = new Path();
    private final RectF rectF = new RectF();
    private final RectF insetRectF = new RectF();
    private final Region transparentRegion = new Region();
    private final Region scratchRegion = new Region();
    private ShapeAppearanceModel strokeShapeAppearance;
    private final Paint fillPaint = new Paint(1);
    private final Paint strokePaint = new Paint(1);
    private final ShadowRenderer shadowRenderer = new ShadowRenderer();
    @NonNull
    private final ShapeAppearancePathProvider.PathListener pathShadowListener;
    private final ShapeAppearancePathProvider pathProvider = Looper.getMainLooper().getThread() == Thread.currentThread() ? ShapeAppearancePathProvider.getInstance() : new ShapeAppearancePathProvider();
    @Nullable
    private PorterDuffColorFilter tintFilter;
    @Nullable
    private PorterDuffColorFilter strokeTintFilter;
    private int resolvedTintColor;
    @NonNull
    private final RectF pathBounds = new RectF();
    private boolean shadowBitmapDrawingEnable = true;

    @NonNull
    public static MaterialShapeDrawable createWithElevationOverlay(Context context) {
        return MaterialShapeDrawable.createWithElevationOverlay(context, 0.0f);
    }

    @NonNull
    public static MaterialShapeDrawable createWithElevationOverlay(Context context, float elevation) {
        int colorSurface = MaterialColors.getColor(context, R.attr.colorSurface, MaterialShapeDrawable.class.getSimpleName());
        MaterialShapeDrawable materialShapeDrawable = new MaterialShapeDrawable();
        materialShapeDrawable.initializeElevationOverlay(context);
        materialShapeDrawable.setFillColor(ColorStateList.valueOf((int)colorSurface));
        materialShapeDrawable.setElevation(elevation);
        return materialShapeDrawable;
    }

    public MaterialShapeDrawable() {
        this(new ShapeAppearanceModel());
    }

    public MaterialShapeDrawable(@NonNull Context context, @Nullable AttributeSet attrs, @AttrRes int defStyleAttr, @StyleRes int defStyleRes) {
        this(ShapeAppearanceModel.builder(context, attrs, defStyleAttr, defStyleRes).build());
    }

    @Deprecated
    public MaterialShapeDrawable(@NonNull ShapePathModel shapePathModel) {
        this((ShapeAppearanceModel)shapePathModel);
    }

    public MaterialShapeDrawable(@NonNull ShapeAppearanceModel shapeAppearanceModel) {
        this(new MaterialShapeDrawableState(shapeAppearanceModel, null));
    }

    private MaterialShapeDrawable(@NonNull MaterialShapeDrawableState drawableState) {
        this.drawableState = drawableState;
        this.strokePaint.setStyle(Paint.Style.STROKE);
        this.fillPaint.setStyle(Paint.Style.FILL);
        this.updateTintFilter();
        this.updateColorsForState(this.getState());
        this.pathShadowListener = new ShapeAppearancePathProvider.PathListener(){

            @Override
            public void onCornerPathCreated(@NonNull ShapePath cornerPath, Matrix transform, int count) {
                MaterialShapeDrawable.this.containsIncompatibleShadowOp.set(count, cornerPath.containsIncompatibleShadowOp());
                ((MaterialShapeDrawable)MaterialShapeDrawable.this).cornerShadowOperation[count] = cornerPath.createShadowCompatOperation(transform);
            }

            @Override
            public void onEdgePathCreated(@NonNull ShapePath edgePath, Matrix transform, int count) {
                MaterialShapeDrawable.this.containsIncompatibleShadowOp.set(count + 4, edgePath.containsIncompatibleShadowOp());
                ((MaterialShapeDrawable)MaterialShapeDrawable.this).edgeShadowOperation[count] = edgePath.createShadowCompatOperation(transform);
            }
        };
    }

    @Nullable
    public Drawable.ConstantState getConstantState() {
        return this.drawableState;
    }

    @NonNull
    public Drawable mutate() {
        MaterialShapeDrawableState newDrawableState;
        this.drawableState = newDrawableState = new MaterialShapeDrawableState(this.drawableState);
        return this;
    }

    private static int modulateAlpha(int paintAlpha, int alpha) {
        int scale = alpha + (alpha >>> 7);
        return paintAlpha * scale >>> 8;
    }

    @Override
    public void setShapeAppearanceModel(@NonNull ShapeAppearanceModel shapeAppearanceModel) {
        this.drawableState.shapeAppearanceModel = shapeAppearanceModel;
        this.invalidateSelf();
    }

    @Override
    @NonNull
    public ShapeAppearanceModel getShapeAppearanceModel() {
        return this.drawableState.shapeAppearanceModel;
    }

    @Deprecated
    public void setShapedViewModel(@NonNull ShapePathModel shapedViewModel) {
        this.setShapeAppearanceModel(shapedViewModel);
    }

    @Deprecated
    @Nullable
    public ShapePathModel getShapedViewModel() {
        ShapeAppearanceModel shapeAppearance = this.getShapeAppearanceModel();
        return shapeAppearance instanceof ShapePathModel ? (ShapePathModel)shapeAppearance : null;
    }

    public void setFillColor(@Nullable ColorStateList fillColor) {
        if (this.drawableState.fillColor != fillColor) {
            this.drawableState.fillColor = fillColor;
            this.onStateChange(this.getState());
        }
    }

    @Nullable
    public ColorStateList getFillColor() {
        return this.drawableState.fillColor;
    }

    public void setStrokeColor(@Nullable ColorStateList strokeColor) {
        if (this.drawableState.strokeColor != strokeColor) {
            this.drawableState.strokeColor = strokeColor;
            this.onStateChange(this.getState());
        }
    }

    @Nullable
    public ColorStateList getStrokeColor() {
        return this.drawableState.strokeColor;
    }

    public void setTintMode(@Nullable PorterDuff.Mode tintMode) {
        if (this.drawableState.tintMode != tintMode) {
            this.drawableState.tintMode = tintMode;
            this.updateTintFilter();
            this.invalidateSelfIgnoreShape();
        }
    }

    public void setTintList(@Nullable ColorStateList tintList) {
        this.drawableState.tintList = tintList;
        this.updateTintFilter();
        this.invalidateSelfIgnoreShape();
    }

    @Nullable
    public ColorStateList getTintList() {
        return this.drawableState.tintList;
    }

    @Nullable
    public ColorStateList getStrokeTintList() {
        return this.drawableState.strokeTintList;
    }

    public void setTint(@ColorInt int tintColor) {
        this.setTintList(ColorStateList.valueOf((int)tintColor));
    }

    public void setStrokeTint(ColorStateList tintList) {
        this.drawableState.strokeTintList = tintList;
        this.updateTintFilter();
        this.invalidateSelfIgnoreShape();
    }

    public void setStrokeTint(@ColorInt int tintColor) {
        this.setStrokeTint(ColorStateList.valueOf((int)tintColor));
    }

    public void setStroke(float strokeWidth, @ColorInt int strokeColor) {
        this.setStrokeWidth(strokeWidth);
        this.setStrokeColor(ColorStateList.valueOf((int)strokeColor));
    }

    public void setStroke(float strokeWidth, @Nullable ColorStateList strokeColor) {
        this.setStrokeWidth(strokeWidth);
        this.setStrokeColor(strokeColor);
    }

    public float getStrokeWidth() {
        return this.drawableState.strokeWidth;
    }

    public void setStrokeWidth(float strokeWidth) {
        this.drawableState.strokeWidth = strokeWidth;
        this.invalidateSelf();
    }

    @ColorInt
    public int getResolvedTintColor() {
        return this.resolvedTintColor;
    }

    public int getOpacity() {
        return -3;
    }

    public int getAlpha() {
        return this.drawableState.alpha;
    }

    public void setAlpha(@IntRange(from=0L, to=255L) int alpha) {
        if (this.drawableState.alpha != alpha) {
            this.drawableState.alpha = alpha;
            this.invalidateSelfIgnoreShape();
        }
    }

    public void setColorFilter(@Nullable ColorFilter colorFilter) {
        this.drawableState.colorFilter = colorFilter;
        this.invalidateSelfIgnoreShape();
    }

    public Region getTransparentRegion() {
        Rect bounds = this.getBounds();
        this.transparentRegion.set(bounds);
        this.calculatePath(this.getBoundsAsRectF(), this.path);
        this.scratchRegion.setPath(this.path, this.transparentRegion);
        this.transparentRegion.op(this.scratchRegion, Region.Op.DIFFERENCE);
        return this.transparentRegion;
    }

    @NonNull
    protected RectF getBoundsAsRectF() {
        this.rectF.set(this.getBounds());
        return this.rectF;
    }

    public void setCornerSize(float cornerSize) {
        this.setShapeAppearanceModel(this.drawableState.shapeAppearanceModel.withCornerSize(cornerSize));
    }

    public void setCornerSize(@NonNull CornerSize cornerSize) {
        this.setShapeAppearanceModel(this.drawableState.shapeAppearanceModel.withCornerSize(cornerSize));
    }

    public boolean isPointInTransparentRegion(int x, int y) {
        return this.getTransparentRegion().contains(x, y);
    }

    public int getShadowCompatibilityMode() {
        return this.drawableState.shadowCompatMode;
    }

    public boolean getPadding(@NonNull Rect padding) {
        if (this.drawableState.padding != null) {
            padding.set(this.drawableState.padding);
            return true;
        }
        return super.getPadding(padding);
    }

    public void setPadding(int left, int top, int right, int bottom) {
        if (this.drawableState.padding == null) {
            this.drawableState.padding = new Rect();
        }
        this.drawableState.padding.set(left, top, right, bottom);
        this.invalidateSelf();
    }

    public void setShadowCompatibilityMode(int mode) {
        if (this.drawableState.shadowCompatMode != mode) {
            this.drawableState.shadowCompatMode = mode;
            this.invalidateSelfIgnoreShape();
        }
    }

    @Deprecated
    public boolean isShadowEnabled() {
        return this.drawableState.shadowCompatMode == 0 || this.drawableState.shadowCompatMode == 2;
    }

    @Deprecated
    public void setShadowEnabled(boolean shadowEnabled) {
        this.setShadowCompatibilityMode(shadowEnabled ? 0 : 1);
    }

    public boolean isElevationOverlayEnabled() {
        return this.drawableState.elevationOverlayProvider != null && this.drawableState.elevationOverlayProvider.isThemeElevationOverlayEnabled();
    }

    public boolean isElevationOverlayInitialized() {
        return this.drawableState.elevationOverlayProvider != null;
    }

    public void initializeElevationOverlay(Context context) {
        this.drawableState.elevationOverlayProvider = new ElevationOverlayProvider(context);
        this.updateZ();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    @ColorInt
    protected int compositeElevationOverlayIfNeeded(@ColorInt int backgroundColor) {
        float elevation = this.getZ() + this.getParentAbsoluteElevation();
        return this.drawableState.elevationOverlayProvider != null ? this.drawableState.elevationOverlayProvider.compositeOverlayIfNeeded(backgroundColor, elevation) : backgroundColor;
    }

    public float getInterpolation() {
        return this.drawableState.interpolation;
    }

    public void setInterpolation(float interpolation) {
        if (this.drawableState.interpolation != interpolation) {
            this.drawableState.interpolation = interpolation;
            this.pathDirty = true;
            this.invalidateSelf();
        }
    }

    public float getParentAbsoluteElevation() {
        return this.drawableState.parentAbsoluteElevation;
    }

    public void setParentAbsoluteElevation(float parentAbsoluteElevation) {
        if (this.drawableState.parentAbsoluteElevation != parentAbsoluteElevation) {
            this.drawableState.parentAbsoluteElevation = parentAbsoluteElevation;
            this.updateZ();
        }
    }

    public float getElevation() {
        return this.drawableState.elevation;
    }

    public void setElevation(float elevation) {
        if (this.drawableState.elevation != elevation) {
            this.drawableState.elevation = elevation;
            this.updateZ();
        }
    }

    public float getTranslationZ() {
        return this.drawableState.translationZ;
    }

    public void setTranslationZ(float translationZ) {
        if (this.drawableState.translationZ != translationZ) {
            this.drawableState.translationZ = translationZ;
            this.updateZ();
        }
    }

    public float getZ() {
        return this.getElevation() + this.getTranslationZ();
    }

    public void setZ(float z) {
        this.setTranslationZ(z - this.getElevation());
    }

    private void updateZ() {
        float z = this.getZ();
        this.drawableState.shadowCompatRadius = (int)Math.ceil(z * 0.75f);
        this.drawableState.shadowCompatOffset = (int)Math.ceil(z * 0.25f);
        this.updateTintFilter();
        this.invalidateSelfIgnoreShape();
    }

    @Deprecated
    public int getShadowElevation() {
        return (int)this.getElevation();
    }

    @Deprecated
    public void setShadowElevation(int shadowElevation) {
        this.setElevation(shadowElevation);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public int getShadowVerticalOffset() {
        return this.drawableState.shadowCompatOffset;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setShadowBitmapDrawingEnable(boolean enable) {
        this.shadowBitmapDrawingEnable = enable;
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setEdgeIntersectionCheckEnable(boolean enable) {
        this.pathProvider.setEdgeIntersectionCheckEnable(enable);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public void setShadowVerticalOffset(int shadowOffset) {
        if (this.drawableState.shadowCompatOffset != shadowOffset) {
            this.drawableState.shadowCompatOffset = shadowOffset;
            this.invalidateSelfIgnoreShape();
        }
    }

    public int getShadowCompatRotation() {
        return this.drawableState.shadowCompatRotation;
    }

    public void setShadowCompatRotation(int shadowRotation) {
        if (this.drawableState.shadowCompatRotation != shadowRotation) {
            this.drawableState.shadowCompatRotation = shadowRotation;
            this.invalidateSelfIgnoreShape();
        }
    }

    public int getShadowRadius() {
        return this.drawableState.shadowCompatRadius;
    }

    @Deprecated
    public void setShadowRadius(int shadowRadius) {
        this.drawableState.shadowCompatRadius = shadowRadius;
    }

    public boolean requiresCompatShadow() {
        return Build.VERSION.SDK_INT < 21 || !this.isRoundRect() && !this.path.isConvex() && Build.VERSION.SDK_INT < 29;
    }

    public float getScale() {
        return this.drawableState.scale;
    }

    public void setScale(float scale) {
        if (this.drawableState.scale != scale) {
            this.drawableState.scale = scale;
            this.invalidateSelf();
        }
    }

    public void invalidateSelf() {
        this.pathDirty = true;
        super.invalidateSelf();
    }

    private void invalidateSelfIgnoreShape() {
        super.invalidateSelf();
    }

    public void setUseTintColorForShadow(boolean useTintColorForShadow) {
        if (this.drawableState.useTintColorForShadow != useTintColorForShadow) {
            this.drawableState.useTintColorForShadow = useTintColorForShadow;
            this.invalidateSelf();
        }
    }

    public void setShadowColor(int shadowColor) {
        this.shadowRenderer.setShadowColor(shadowColor);
        this.drawableState.useTintColorForShadow = false;
        this.invalidateSelfIgnoreShape();
    }

    public Paint.Style getPaintStyle() {
        return this.drawableState.paintStyle;
    }

    public void setPaintStyle(Paint.Style paintStyle) {
        this.drawableState.paintStyle = paintStyle;
        this.invalidateSelfIgnoreShape();
    }

    private boolean hasCompatShadow() {
        return this.drawableState.shadowCompatMode != 1 && this.drawableState.shadowCompatRadius > 0 && (this.drawableState.shadowCompatMode == 2 || this.requiresCompatShadow());
    }

    private boolean hasFill() {
        return this.drawableState.paintStyle == Paint.Style.FILL_AND_STROKE || this.drawableState.paintStyle == Paint.Style.FILL;
    }

    private boolean hasStroke() {
        return (this.drawableState.paintStyle == Paint.Style.FILL_AND_STROKE || this.drawableState.paintStyle == Paint.Style.STROKE) && this.strokePaint.getStrokeWidth() > 0.0f;
    }

    protected void onBoundsChange(Rect bounds) {
        this.pathDirty = true;
        super.onBoundsChange(bounds);
    }

    public void draw(@NonNull Canvas canvas) {
        this.fillPaint.setColorFilter((ColorFilter)this.tintFilter);
        int prevAlpha = this.fillPaint.getAlpha();
        this.fillPaint.setAlpha(MaterialShapeDrawable.modulateAlpha(prevAlpha, this.drawableState.alpha));
        this.strokePaint.setColorFilter((ColorFilter)this.strokeTintFilter);
        this.strokePaint.setStrokeWidth(this.drawableState.strokeWidth);
        int prevStrokeAlpha = this.strokePaint.getAlpha();
        this.strokePaint.setAlpha(MaterialShapeDrawable.modulateAlpha(prevStrokeAlpha, this.drawableState.alpha));
        if (this.pathDirty) {
            this.calculateStrokePath();
            this.calculatePath(this.getBoundsAsRectF(), this.path);
            this.pathDirty = false;
        }
        this.maybeDrawCompatShadow(canvas);
        if (this.hasFill()) {
            this.drawFillShape(canvas);
        }
        if (this.hasStroke()) {
            this.drawStrokeShape(canvas);
        }
        this.fillPaint.setAlpha(prevAlpha);
        this.strokePaint.setAlpha(prevStrokeAlpha);
    }

    private void maybeDrawCompatShadow(@NonNull Canvas canvas) {
        if (!this.hasCompatShadow()) {
            return;
        }
        canvas.save();
        this.prepareCanvasForShadow(canvas);
        if (!this.shadowBitmapDrawingEnable) {
            this.drawCompatShadow(canvas);
            canvas.restore();
            return;
        }
        int pathExtraWidth = (int)(this.pathBounds.width() - (float)this.getBounds().width());
        int pathExtraHeight = (int)(this.pathBounds.height() - (float)this.getBounds().height());
        if (pathExtraWidth < 0 || pathExtraHeight < 0) {
            throw new IllegalStateException("Invalid shadow bounds. Check that the treatments result in a valid path.");
        }
        Bitmap shadowLayer = Bitmap.createBitmap((int)((int)this.pathBounds.width() + this.drawableState.shadowCompatRadius * 2 + pathExtraWidth), (int)((int)this.pathBounds.height() + this.drawableState.shadowCompatRadius * 2 + pathExtraHeight), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas shadowCanvas = new Canvas(shadowLayer);
        float shadowLeft = this.getBounds().left - this.drawableState.shadowCompatRadius - pathExtraWidth;
        float shadowTop = this.getBounds().top - this.drawableState.shadowCompatRadius - pathExtraHeight;
        shadowCanvas.translate(-shadowLeft, -shadowTop);
        this.drawCompatShadow(shadowCanvas);
        canvas.drawBitmap(shadowLayer, shadowLeft, shadowTop, null);
        shadowLayer.recycle();
        canvas.restore();
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void drawShape(@NonNull Canvas canvas, @NonNull Paint paint, @NonNull Path path, @NonNull RectF bounds) {
        this.drawShape(canvas, paint, path, this.drawableState.shapeAppearanceModel, bounds);
    }

    private void drawShape(@NonNull Canvas canvas, @NonNull Paint paint, @NonNull Path path, @NonNull ShapeAppearanceModel shapeAppearanceModel, @NonNull RectF bounds) {
        if (shapeAppearanceModel.isRoundRect(bounds)) {
            float cornerSize = shapeAppearanceModel.getTopRightCornerSize().getCornerSize(bounds) * this.drawableState.interpolation;
            canvas.drawRoundRect(bounds, cornerSize, cornerSize, paint);
        } else {
            canvas.drawPath(path, paint);
        }
    }

    private void drawFillShape(@NonNull Canvas canvas) {
        this.drawShape(canvas, this.fillPaint, this.path, this.drawableState.shapeAppearanceModel, this.getBoundsAsRectF());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected void drawStrokeShape(@NonNull Canvas canvas) {
        this.drawShape(canvas, this.strokePaint, this.pathInsetByStroke, this.strokeShapeAppearance, this.getBoundsInsetByStroke());
    }

    private void prepareCanvasForShadow(@NonNull Canvas canvas) {
        int shadowOffsetX = this.getShadowOffsetX();
        int shadowOffsetY = this.getShadowOffsetY();
        if (Build.VERSION.SDK_INT < 21 && this.shadowBitmapDrawingEnable) {
            Rect canvasClipBounds = canvas.getClipBounds();
            canvasClipBounds.inset(-this.drawableState.shadowCompatRadius, -this.drawableState.shadowCompatRadius);
            canvasClipBounds.offset(shadowOffsetX, shadowOffsetY);
            canvas.clipRect(canvasClipBounds, Region.Op.REPLACE);
        }
        canvas.translate((float)shadowOffsetX, (float)shadowOffsetY);
    }

    private void drawCompatShadow(@NonNull Canvas canvas) {
        if (this.containsIncompatibleShadowOp.cardinality() > 0) {
            Log.w((String)TAG, (String)"Compatibility shadow requested but can't be drawn for all operations in this shape.");
        }
        if (this.drawableState.shadowCompatOffset != 0) {
            canvas.drawPath(this.path, this.shadowRenderer.getShadowPaint());
        }
        for (int index = 0; index < 4; ++index) {
            this.cornerShadowOperation[index].draw(this.shadowRenderer, this.drawableState.shadowCompatRadius, canvas);
            this.edgeShadowOperation[index].draw(this.shadowRenderer, this.drawableState.shadowCompatRadius, canvas);
        }
        if (this.shadowBitmapDrawingEnable) {
            int shadowOffsetX = this.getShadowOffsetX();
            int shadowOffsetY = this.getShadowOffsetY();
            canvas.translate((float)(-shadowOffsetX), (float)(-shadowOffsetY));
            canvas.drawPath(this.path, clearPaint);
            canvas.translate((float)shadowOffsetX, (float)shadowOffsetY);
        }
    }

    public int getShadowOffsetX() {
        return (int)((double)this.drawableState.shadowCompatOffset * Math.sin(Math.toRadians(this.drawableState.shadowCompatRotation)));
    }

    public int getShadowOffsetY() {
        return (int)((double)this.drawableState.shadowCompatOffset * Math.cos(Math.toRadians(this.drawableState.shadowCompatRotation)));
    }

    @Deprecated
    public void getPathForSize(int width, int height, @NonNull Path path) {
        this.calculatePathForSize(new RectF(0.0f, 0.0f, (float)width, (float)height), path);
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    protected final void calculatePathForSize(@NonNull RectF bounds, @NonNull Path path) {
        this.pathProvider.calculatePath(this.drawableState.shapeAppearanceModel, this.drawableState.interpolation, bounds, this.pathShadowListener, path);
    }

    private void calculateStrokePath() {
        final float strokeInsetLength = -this.getStrokeInsetLength();
        this.strokeShapeAppearance = this.getShapeAppearanceModel().withTransformedCornerSizes(new ShapeAppearanceModel.CornerSizeUnaryOperator(){

            @Override
            @NonNull
            public CornerSize apply(@NonNull CornerSize cornerSize) {
                return cornerSize instanceof RelativeCornerSize ? cornerSize : new AdjustedCornerSize(strokeInsetLength, cornerSize);
            }
        });
        this.pathProvider.calculatePath(this.strokeShapeAppearance, this.drawableState.interpolation, this.getBoundsInsetByStroke(), this.pathInsetByStroke);
    }

    @TargetApi(value=21)
    public void getOutline(@NonNull Outline outline) {
        if (this.drawableState.shadowCompatMode == 2) {
            return;
        }
        if (this.isRoundRect()) {
            float radius = this.getTopLeftCornerResolvedSize() * this.drawableState.interpolation;
            outline.setRoundRect(this.getBounds(), radius);
            return;
        }
        this.calculatePath(this.getBoundsAsRectF(), this.path);
        if (this.path.isConvex() || Build.VERSION.SDK_INT >= 29) {
            try {
                outline.setConvexPath(this.path);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void calculatePath(@NonNull RectF bounds, @NonNull Path path) {
        this.calculatePathForSize(bounds, path);
        if (this.drawableState.scale != 1.0f) {
            this.matrix.reset();
            this.matrix.setScale(this.drawableState.scale, this.drawableState.scale, bounds.width() / 2.0f, bounds.height() / 2.0f);
            path.transform(this.matrix);
        }
        path.computeBounds(this.pathBounds, true);
    }

    private boolean updateTintFilter() {
        PorterDuffColorFilter originalTintFilter = this.tintFilter;
        PorterDuffColorFilter originalStrokeTintFilter = this.strokeTintFilter;
        this.tintFilter = this.calculateTintFilter(this.drawableState.tintList, this.drawableState.tintMode, this.fillPaint, true);
        this.strokeTintFilter = this.calculateTintFilter(this.drawableState.strokeTintList, this.drawableState.tintMode, this.strokePaint, false);
        if (this.drawableState.useTintColorForShadow) {
            this.shadowRenderer.setShadowColor(this.drawableState.tintList.getColorForState(this.getState(), 0));
        }
        return !ObjectsCompat.equals((Object)originalTintFilter, (Object)this.tintFilter) || !ObjectsCompat.equals((Object)originalStrokeTintFilter, (Object)this.strokeTintFilter);
    }

    @NonNull
    private PorterDuffColorFilter calculateTintFilter(@Nullable ColorStateList tintList, @Nullable PorterDuff.Mode tintMode, @NonNull Paint paint, boolean requiresElevationOverlay) {
        return tintList == null || tintMode == null ? this.calculatePaintColorTintFilter(paint, requiresElevationOverlay) : this.calculateTintColorTintFilter(tintList, tintMode, requiresElevationOverlay);
    }

    @Nullable
    private PorterDuffColorFilter calculatePaintColorTintFilter(@NonNull Paint paint, boolean requiresElevationOverlay) {
        if (requiresElevationOverlay) {
            int tintColor;
            int paintColor = paint.getColor();
            this.resolvedTintColor = tintColor = this.compositeElevationOverlayIfNeeded(paintColor);
            if (tintColor != paintColor) {
                return new PorterDuffColorFilter(tintColor, PorterDuff.Mode.SRC_IN);
            }
        }
        return null;
    }

    @NonNull
    private PorterDuffColorFilter calculateTintColorTintFilter(@NonNull ColorStateList tintList, @NonNull PorterDuff.Mode tintMode, boolean requiresElevationOverlay) {
        int tintColor = tintList.getColorForState(this.getState(), 0);
        if (requiresElevationOverlay) {
            tintColor = this.compositeElevationOverlayIfNeeded(tintColor);
        }
        this.resolvedTintColor = tintColor;
        return new PorterDuffColorFilter(tintColor, tintMode);
    }

    public boolean isStateful() {
        return super.isStateful() || this.drawableState.tintList != null && this.drawableState.tintList.isStateful() || this.drawableState.strokeTintList != null && this.drawableState.strokeTintList.isStateful() || this.drawableState.strokeColor != null && this.drawableState.strokeColor.isStateful() || this.drawableState.fillColor != null && this.drawableState.fillColor.isStateful();
    }

    protected boolean onStateChange(int[] state) {
        boolean invalidateSelf;
        boolean paintColorChanged = this.updateColorsForState(state);
        boolean tintFilterChanged = this.updateTintFilter();
        boolean bl = invalidateSelf = paintColorChanged || tintFilterChanged;
        if (invalidateSelf) {
            this.invalidateSelf();
        }
        return invalidateSelf;
    }

    private boolean updateColorsForState(int[] state) {
        int newStrokeColor;
        int previousStrokeColor;
        int newFillColor;
        int previousFillColor;
        boolean invalidateSelf = false;
        if (this.drawableState.fillColor != null && (previousFillColor = this.fillPaint.getColor()) != (newFillColor = this.drawableState.fillColor.getColorForState(state, previousFillColor))) {
            this.fillPaint.setColor(newFillColor);
            invalidateSelf = true;
        }
        if (this.drawableState.strokeColor != null && (previousStrokeColor = this.strokePaint.getColor()) != (newStrokeColor = this.drawableState.strokeColor.getColorForState(state, previousStrokeColor))) {
            this.strokePaint.setColor(newStrokeColor);
            invalidateSelf = true;
        }
        return invalidateSelf;
    }

    private float getStrokeInsetLength() {
        if (this.hasStroke()) {
            return this.strokePaint.getStrokeWidth() / 2.0f;
        }
        return 0.0f;
    }

    @NonNull
    private RectF getBoundsInsetByStroke() {
        this.insetRectF.set(this.getBoundsAsRectF());
        float inset = this.getStrokeInsetLength();
        this.insetRectF.inset(inset, inset);
        return this.insetRectF;
    }

    public float getTopLeftCornerResolvedSize() {
        return this.drawableState.shapeAppearanceModel.getTopLeftCornerSize().getCornerSize(this.getBoundsAsRectF());
    }

    public float getTopRightCornerResolvedSize() {
        return this.drawableState.shapeAppearanceModel.getTopRightCornerSize().getCornerSize(this.getBoundsAsRectF());
    }

    public float getBottomLeftCornerResolvedSize() {
        return this.drawableState.shapeAppearanceModel.getBottomLeftCornerSize().getCornerSize(this.getBoundsAsRectF());
    }

    public float getBottomRightCornerResolvedSize() {
        return this.drawableState.shapeAppearanceModel.getBottomRightCornerSize().getCornerSize(this.getBoundsAsRectF());
    }

    @RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
    public boolean isRoundRect() {
        return this.drawableState.shapeAppearanceModel.isRoundRect(this.getBoundsAsRectF());
    }

    static {
        clearPaint.setColor(-1);
        clearPaint.setXfermode((Xfermode)new PorterDuffXfermode(PorterDuff.Mode.DST_OUT));
    }

    static final class MaterialShapeDrawableState
    extends Drawable.ConstantState {
        @NonNull
        public ShapeAppearanceModel shapeAppearanceModel;
        @Nullable
        public ElevationOverlayProvider elevationOverlayProvider;
        @Nullable
        public ColorFilter colorFilter;
        @Nullable
        public ColorStateList fillColor = null;
        @Nullable
        public ColorStateList strokeColor = null;
        @Nullable
        public ColorStateList strokeTintList = null;
        @Nullable
        public ColorStateList tintList = null;
        @Nullable
        public PorterDuff.Mode tintMode = PorterDuff.Mode.SRC_IN;
        @Nullable
        public Rect padding = null;
        public float scale = 1.0f;
        public float interpolation = 1.0f;
        public float strokeWidth;
        public int alpha = 255;
        public float parentAbsoluteElevation = 0.0f;
        public float elevation = 0.0f;
        public float translationZ = 0.0f;
        public int shadowCompatMode = 0;
        public int shadowCompatRadius = 0;
        public int shadowCompatOffset = 0;
        public int shadowCompatRotation = 0;
        public boolean useTintColorForShadow = false;
        public Paint.Style paintStyle = Paint.Style.FILL_AND_STROKE;

        public MaterialShapeDrawableState(ShapeAppearanceModel shapeAppearanceModel, ElevationOverlayProvider elevationOverlayProvider) {
            this.shapeAppearanceModel = shapeAppearanceModel;
            this.elevationOverlayProvider = elevationOverlayProvider;
        }

        public MaterialShapeDrawableState(@NonNull MaterialShapeDrawableState orig) {
            this.shapeAppearanceModel = orig.shapeAppearanceModel;
            this.elevationOverlayProvider = orig.elevationOverlayProvider;
            this.strokeWidth = orig.strokeWidth;
            this.colorFilter = orig.colorFilter;
            this.fillColor = orig.fillColor;
            this.strokeColor = orig.strokeColor;
            this.tintMode = orig.tintMode;
            this.tintList = orig.tintList;
            this.alpha = orig.alpha;
            this.scale = orig.scale;
            this.shadowCompatOffset = orig.shadowCompatOffset;
            this.shadowCompatMode = orig.shadowCompatMode;
            this.useTintColorForShadow = orig.useTintColorForShadow;
            this.interpolation = orig.interpolation;
            this.parentAbsoluteElevation = orig.parentAbsoluteElevation;
            this.elevation = orig.elevation;
            this.translationZ = orig.translationZ;
            this.shadowCompatRadius = orig.shadowCompatRadius;
            this.shadowCompatRotation = orig.shadowCompatRotation;
            this.strokeTintList = orig.strokeTintList;
            this.paintStyle = orig.paintStyle;
            if (orig.padding != null) {
                this.padding = new Rect(orig.padding);
            }
        }

        @NonNull
        public Drawable newDrawable() {
            MaterialShapeDrawable msd = new MaterialShapeDrawable(this);
            msd.pathDirty = true;
            return msd;
        }

        public int getChangingConfigurations() {
            return 0;
        }
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface CompatibilityShadowMode {
    }
}

