/*
 * Decompiled with CFR 0.152.
 */
package com.google.android.material.navigationrail;

import android.content.Context;
import android.view.View;
import androidx.annotation.DimenRes;
import androidx.annotation.LayoutRes;
import androidx.annotation.NonNull;
import androidx.annotation.RestrictTo;
import com.google.android.material.R;
import com.google.android.material.navigation.NavigationBarItemView;

@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
final class NavigationRailItemView
extends NavigationBarItemView {
    public NavigationRailItemView(@NonNull Context context) {
        super(context);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (View.MeasureSpec.getMode((int)heightMeasureSpec) == 0) {
            int preferredHeight = View.MeasureSpec.getSize((int)heightMeasureSpec);
            int measuredHeight = this.getMeasuredHeight();
            int bestHeight = Math.max(measuredHeight, preferredHeight);
            this.setMeasuredDimension(this.getMeasuredWidthAndState(), View.resolveSizeAndState((int)bestHeight, (int)heightMeasureSpec, (int)0));
        }
    }

    @Override
    @LayoutRes
    protected int getItemLayoutResId() {
        return R.layout.mtrl_navigation_rail_item;
    }

    @Override
    @DimenRes
    protected int getItemDefaultMarginResId() {
        return R.dimen.mtrl_navigation_rail_icon_margin;
    }
}

